/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.common.grid;

import eu.unicore.hila.Location;
import eu.unicore.hila.Resource;
import eu.unicore.hila.common.BaseResource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.Site;
import eu.unicore.hila.grid.Storage;
import eu.unicore.hila.grid.job.JobDescription;
import eu.unicore.hila.job.model.MappingFactory;
import eu.unicore.hila.job.spi.NoSuchMappingException;
import java.util.ArrayList;
import java.util.List;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;

public abstract class BaseSite
extends BaseResource
implements Site {
    private volatile List<Resource> children;

    public BaseSite(Location _location) {
        super(_location);
    }

    @Override
    public List<Storage> getStorages() throws HiLAException {
        ArrayList<Storage> storages = new ArrayList<Storage>();
        return storages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Resource> getChildren() throws HiLALocationSyntaxException {
        if (this.children == null) {
            BaseSite baseSite = this;
            synchronized (baseSite) {
                if (this.children == null) {
                    this.children = new ArrayList<Resource>();
                    Location tasksLocation = this.location.getChildLocation("tasks");
                    Location storagesLocation = this.location.getChildLocation("storages");
                    try {
                        Resource tasks = tasksLocation.locate(new Object[0]);
                        this.children.add(tasks);
                    }
                    catch (HiLAException e) {
                        // empty catch block
                    }
                    try {
                        Resource storages = storagesLocation.locate(new Object[0]);
                        this.children.add(storages);
                    }
                    catch (HiLAException e) {
                        // empty catch block
                    }
                }
            }
        }
        return this.children;
    }

    @Override
    public Job submit(JobDescription _jd) throws HiLAException {
        if (_jd.getActualJobDescription() instanceof JobDefinitionDocument) {
            JobDefinitionDocument jsdl = (JobDefinitionDocument)_jd.getActualJobDescription();
            try {
                return this.submit(MappingFactory.getMapping("jsdl").createNativeToModelMapping(jsdl).getModel());
            }
            catch (NoSuchMappingException e) {
                throw new HiLAException("Unable to map input JobDescription to the job model.", e);
            }
        }
        throw new HiLAFactoryException("Unable to map input JobDescription to the job model.");
    }
}

