/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es.clients;

import eu.emi.es.x2010.x12.resourceinfo.DefaultQueryDialectsEnumType;
import eu.emi.es.x2010.x12.resourceinfo.GetResourceInfoDocument;
import eu.emi.es.x2010.x12.resourceinfo.GetResourceInfoResponseDocument;
import eu.emi.es.x2010.x12.resourceinfo.QueryExpressionType;
import eu.emi.es.x2010.x12.resourceinfo.QueryResourceInfoDocument;
import eu.emi.es.x2010.x12.resourceinfo.QueryResourceInfoResponseDocument;
import eu.unicore.emi.es.ResourceInfoService;
import eu.unicore.emi.es.faults.AccessControlFault;
import eu.unicore.emi.es.faults.InternalBaseFault;
import eu.unicore.emi.es.faults.InternalResourceInfoException;
import eu.unicore.emi.es.faults.NotSupportedQueryDialectException;
import eu.unicore.emi.es.faults.NotValidQueryStatementException;
import eu.unicore.emi.es.faults.ResourceInfoNotFoundException;
import eu.unicore.emi.es.faults.UnknownQueryException;
import eu.unicore.security.xfireutil.client.UnicoreXFireClientFactory;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.xmlbeans.XmlString;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingEndpointT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingServiceT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.EndpointT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ServiceT;

public class ResourceInfoClient {
    public static final String SERVICE_NAME = "ResourceInfoService";
    public static final String SERVICE_PATH = "/ResourceInfoService";
    final ResourceInfoService ris;
    private final String url;
    private final IClientConfiguration sp;

    public ResourceInfoClient(String _url, IClientConfiguration _sp) throws MalformedURLException {
        this.url = _url;
        this.sp = _sp;
        this.ris = new UnicoreXFireClientFactory(_sp).createPlainWSProxy(ResourceInfoService.class, _url);
    }

    public List<String> getQueryDialects() throws InternalResourceInfoException, AccessControlFault, ResourceInfoNotFoundException, InternalBaseFault {
        ServiceT[] serviceArray;
        int n;
        int n2;
        ComputingServiceT[] computingServiceArray;
        HashSet<String> dialects = new HashSet<String>();
        GetResourceInfoResponseDocument.GetResourceInfoResponse resourceInfoResponse = this.getResourceInfo().getGetResourceInfoResponse();
        ComputingServiceT[] computingServiceTArray = computingServiceArray = resourceInfoResponse.getServices().getComputingServiceArray();
        int n3 = computingServiceArray.length;
        int n4 = 0;
        while (n4 < n3) {
            ComputingEndpointT[] ces;
            ComputingServiceT cs = computingServiceTArray[n4];
            ComputingEndpointT[] computingEndpointTArray = ces = cs.getComputingEndpointArray();
            n2 = ces.length;
            int n5 = 0;
            while (n5 < n2) {
                ComputingEndpointT computingEndpointT = computingEndpointTArray[n5];
                String[] stringArray = computingEndpointT.getCapabilityArray();
                n = stringArray.length;
                int n6 = 0;
                while (n6 < n) {
                    String cap = stringArray[n6];
                    dialects.add(cap);
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        ServiceT[] serviceTArray = serviceArray = resourceInfoResponse.getServices().getServiceArray();
        int n7 = serviceArray.length;
        n3 = 0;
        while (n3 < n7) {
            EndpointT[] ses;
            ServiceT s = serviceTArray[n3];
            EndpointT[] endpointTArray = ses = s.getEndpointArray();
            int n8 = ses.length;
            n2 = 0;
            while (n2 < n8) {
                EndpointT endpointT = endpointTArray[n2];
                String[] stringArray = endpointT.getCapabilityArray();
                int n9 = stringArray.length;
                n = 0;
                while (n < n9) {
                    String cap = stringArray[n];
                    dialects.add(cap);
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        return Collections.list(Collections.enumeration(dialects));
    }

    public GetResourceInfoResponseDocument getResourceInfo() throws InternalResourceInfoException, AccessControlFault, ResourceInfoNotFoundException, InternalBaseFault {
        GetResourceInfoDocument request = GetResourceInfoDocument.Factory.newInstance();
        request.addNewGetResourceInfo();
        return this.ris.GetResourceInfo(request);
    }

    public QueryResourceInfoResponseDocument queryResourceInfo(String query) throws AccessControlFault, NotValidQueryStatementException, InternalBaseFault, NotSupportedQueryDialectException, UnknownQueryException {
        return this.queryResourceInfo(DefaultQueryDialectsEnumType.XPATH_1_0.toString(), query);
    }

    public QueryResourceInfoResponseDocument queryResourceInfo(String dialect, String query) throws AccessControlFault, NotValidQueryStatementException, InternalBaseFault, NotSupportedQueryDialectException, UnknownQueryException {
        QueryResourceInfoDocument doc = QueryResourceInfoDocument.Factory.newInstance();
        QueryResourceInfoDocument.QueryResourceInfo q = doc.addNewQueryResourceInfo();
        q.setQueryDialect(dialect);
        QueryExpressionType exp = q.addNewQueryExpression();
        XmlString queryX = XmlString.Factory.newInstance();
        queryX.setStringValue(query);
        exp.set(queryX);
        return this.queryResourceInfo(doc);
    }

    public QueryResourceInfoResponseDocument queryResourceInfo(QueryResourceInfoDocument expression) throws AccessControlFault, NotValidQueryStatementException, InternalBaseFault, NotSupportedQueryDialectException, UnknownQueryException {
        return this.ris.QueryResourceInfo(expression);
    }

    public String getUrl() {
        return this.url;
    }

    public IClientConfiguration getSecurityProperties() {
        return this.sp;
    }
}

