/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.emi.es.clients;

import eu.emi.es.x2010.x12.activity.ActivityInfoItemDocument;
import eu.emi.es.x2010.x12.activity.ActivityStatusItemDocument;
import eu.emi.es.x2010.x12.activity.GetActivityInfoDocument;
import eu.emi.es.x2010.x12.activity.GetActivityInfoResponseDocument;
import eu.emi.es.x2010.x12.activity.GetActivityStatusDocument;
import eu.emi.es.x2010.x12.activity.GetActivityStatusResponseDocument;
import eu.emi.es.x2010.x12.activitymanagement.CancelActivityDocument;
import eu.emi.es.x2010.x12.activitymanagement.CancelActivityResponseDocument;
import eu.emi.es.x2010.x12.activitymanagement.CancelActivityResponseItemDocument;
import eu.emi.es.x2010.x12.activitymanagement.NotifyMessageType;
import eu.emi.es.x2010.x12.activitymanagement.NotifyRequestItemDocument;
import eu.emi.es.x2010.x12.activitymanagement.NotifyResponseItemDocument;
import eu.emi.es.x2010.x12.activitymanagement.NotifyServiceDocument;
import eu.emi.es.x2010.x12.activitymanagement.NotifyServiceResponseDocument;
import eu.emi.es.x2010.x12.activitymanagement.PauseActivityDocument;
import eu.emi.es.x2010.x12.activitymanagement.PauseActivityResponseDocument;
import eu.emi.es.x2010.x12.activitymanagement.PauseActivityResponseItemDocument;
import eu.emi.es.x2010.x12.activitymanagement.ResumeActivityDocument;
import eu.emi.es.x2010.x12.activitymanagement.ResumeActivityResponseDocument;
import eu.emi.es.x2010.x12.activitymanagement.ResumeActivityResponseItemDocument;
import eu.emi.es.x2010.x12.activitymanagement.WipeActivityDocument;
import eu.emi.es.x2010.x12.activitymanagement.WipeActivityResponseDocument;
import eu.emi.es.x2010.x12.activitymanagement.WipeActivityResponseItemDocument;
import eu.unicore.emi.es.ActivityManagementService;
import eu.unicore.emi.es.faults.AccessControlFault;
import eu.unicore.emi.es.faults.InternalBaseFault;
import eu.unicore.emi.es.faults.UnknownAttributeException;
import eu.unicore.emi.es.faults.VectorLimitExceededFault;
import eu.unicore.security.xfireutil.client.UnicoreXFireClientFactory;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;

public class ActivityManagementClient {
    public static final String SERVICE_NAME = "ActivityManagementService";
    public static final String SERVICE_PATH = "/ActivityManagementService";
    private final ActivityManagementService activityManager;
    private final String endpointUrl;
    private IClientConfiguration sp;

    public ActivityManagementClient(String _endpointUrl, IClientConfiguration sec) throws Exception {
        this.endpointUrl = _endpointUrl;
        this.sp = sec;
        this.activityManager = new UnicoreXFireClientFactory(sec).createPlainWSProxy(ActivityManagementService.class, _endpointUrl);
    }

    public List<ActivityStatusItemDocument.ActivityStatusItem> getActivityStatus(String ... ids) throws InternalBaseFault, VectorLimitExceededFault, AccessControlFault {
        GetActivityStatusDocument status_request = GetActivityStatusDocument.Factory.newInstance();
        status_request.addNewGetActivityStatus().setActivityIDArray(ids);
        GetActivityStatusResponseDocument resp = this.activityManager.getActivityStatus(status_request);
        return Arrays.asList(resp.getGetActivityStatusResponse().getActivityStatusItemArray());
    }

    public CancelActivityResponseItemDocument.CancelActivityResponseItem[] cancelActivity(String ... ids) throws InternalBaseFault, VectorLimitExceededFault, AccessControlFault {
        CancelActivityDocument remove_request = CancelActivityDocument.Factory.newInstance();
        remove_request.addNewCancelActivity().setActivityIDArray(ids);
        CancelActivityResponseDocument resp = this.activityManager.cancelActivity(remove_request);
        return resp.getCancelActivityResponse().getCancelActivityResponseItemArray();
    }

    public PauseActivityResponseItemDocument.PauseActivityResponseItem[] pauseActivity(String ... ids) throws InternalBaseFault, VectorLimitExceededFault, AccessControlFault {
        PauseActivityDocument pause_request = PauseActivityDocument.Factory.newInstance();
        pause_request.addNewPauseActivity().setActivityIDArray(ids);
        PauseActivityResponseDocument resp = this.activityManager.pauseActivity(pause_request);
        return resp.getPauseActivityResponse().getPauseActivityResponseItemArray();
    }

    public ResumeActivityResponseItemDocument.ResumeActivityResponseItem[] resumeActivity(String ... ids) throws InternalBaseFault, VectorLimitExceededFault, AccessControlFault {
        ResumeActivityDocument resume_request = ResumeActivityDocument.Factory.newInstance();
        resume_request.addNewResumeActivity().setActivityIDArray(ids);
        ResumeActivityResponseDocument resp = this.activityManager.resumeActivity(resume_request);
        return resp.getResumeActivityResponse().getResumeActivityResponseItemArray();
    }

    public List<ActivityInfoItemDocument.ActivityInfoItem> getActivityInfo(String ... ids) throws InternalBaseFault, VectorLimitExceededFault, UnknownAttributeException {
        return this.getActivityInfo((QName[])null, ids);
    }

    public List<ActivityInfoItemDocument.ActivityInfoItem> getActivityInfo(QName[] attributes, String ... ids) throws InternalBaseFault, VectorLimitExceededFault, UnknownAttributeException {
        GetActivityInfoDocument getinfo_request = GetActivityInfoDocument.Factory.newInstance();
        getinfo_request.addNewGetActivityInfo().setActivityIDArray(ids);
        GetActivityInfoDocument.GetActivityInfo getActivityInfo = GetActivityInfoDocument.GetActivityInfo.Factory.newInstance();
        getActivityInfo.setActivityIDArray(ids);
        if (attributes != null && attributes.length > 0) {
            getActivityInfo.setAttributeNameArray(attributes);
        }
        getinfo_request.setGetActivityInfo(getActivityInfo);
        GetActivityInfoResponseDocument resp = this.activityManager.getActivityInfo(getinfo_request);
        return Arrays.asList(resp.getGetActivityInfoResponse().getActivityInfoItemArray());
    }

    public NotifyResponseItemDocument.NotifyResponseItem[] dataPushDone(String ... ids) throws InternalBaseFault, VectorLimitExceededFault, AccessControlFault {
        NotifyServiceDocument notify_request = NotifyServiceDocument.Factory.newInstance();
        NotifyServiceDocument.NotifyService notifyInfo = notify_request.addNewNotifyService();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String nreq_id = stringArray[n2];
            NotifyRequestItemDocument.NotifyRequestItem notify = notifyInfo.addNewNotifyRequestItem();
            notify.setActivityID(nreq_id);
            NotifyMessageType.Enum notify_message = null;
            notify_message = NotifyMessageType.CLIENT_DATAPUSH_DONE;
            notify.setNotifyMessage(notify_message);
            ++n2;
        }
        NotifyServiceResponseDocument resp = this.activityManager.notifyService(notify_request);
        return resp.getNotifyServiceResponse().getNotifyResponseItemArray();
    }

    public WipeActivityResponseItemDocument.WipeActivityResponseItem[] wipeActivity(String ... ids) throws InternalBaseFault, VectorLimitExceededFault, AccessControlFault {
        WipeActivityDocument wipe_request = WipeActivityDocument.Factory.newInstance();
        WipeActivityDocument.WipeActivity wipe_activity = wipe_request.addNewWipeActivity();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            wipe_activity.addActivityID(id);
            ++n2;
        }
        WipeActivityResponseDocument wipe_response = this.activityManager.wipeActivity(wipe_request);
        return wipe_response.getWipeActivityResponse().getWipeActivityResponseItemArray();
    }

    public String getURL() {
        return this.endpointUrl;
    }

    public IClientConfiguration getSecurityProperties() {
        return this.sp;
    }
}

