/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans;

import java.util.Calendar;
import javax.xml.namespace.QName;
import org.codehaus.xfire.fault.FaultInfoException;
import org.oasisOpen.docs.wsrf.bf2.BaseFaultDocument;
import org.oasisOpen.docs.wsrf.bf2.BaseFaultType;

public class BaseFault
extends FaultInfoException {
    protected static final long serialVersionUID = 1L;
    private BaseFaultType faultDetail;

    public BaseFault(String message, Throwable cause, BaseFaultType details) {
        super(message, cause);
        this.faultDetail = details;
    }

    public BaseFault(String message, BaseFaultType details) {
        super(message);
        this.faultDetail = details;
    }

    public BaseFault(String message) {
        super(message);
    }

    public BaseFaultType getFaultInfo() {
        return this.faultDetail;
    }

    public static QName getFaultName() {
        return BaseFaultDocument.type.getDocumentElementName();
    }

    public static BaseFault createFault(String message) {
        return BaseFault.createFault(message, null, false);
    }

    public static BaseFault createFault(String message, Throwable cause) {
        return BaseFault.createFault(message, cause, false);
    }

    public static BaseFault createFault(String message, Throwable cause, boolean addDetails) {
        BaseFaultType bft = BaseFaultType.Factory.newInstance();
        bft.setTimestamp(Calendar.getInstance());
        StringBuilder finalMsg = new StringBuilder();
        finalMsg.append(message);
        if (addDetails) {
            if (cause != null && cause.getMessage() != null) {
                finalMsg.append(" Reason: ");
                finalMsg.append(cause.getMessage());
            } else if (cause != null) {
                finalMsg.append(" Reason: ");
                finalMsg.append(cause.toString());
            }
        }
        bft.addNewDescription().setStringValue(finalMsg.toString());
        return cause == null ? new BaseFault(finalMsg.toString(), bft) : new BaseFault(finalMsg.toString(), cause, bft);
    }
}

