/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xfire;

import eu.unicore.security.xfireutil.client.DSigOutHandler;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.addressing.AddressingHeaders;
import org.codehaus.xfire.addressing.AddressingHeadersFactory;
import org.codehaus.xfire.addressing.AddressingHeadersFactory200508;
import org.codehaus.xfire.addressing.AddressingInHandler;
import org.codehaus.xfire.addressing.AddressingOperationInfo;
import org.codehaus.xfire.addressing.AddressingOutHandler;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.service.OperationInfo;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.w3.x2005.x08.addressing.EndpointReferenceType;
import org.w3.x2005.x08.addressing.ReferenceParametersType;

public class WSRFAddressingOutHandler
extends AddressingOutHandler {
    private EndpointReferenceType epr;

    public WSRFAddressingOutHandler() {
        this.before(DSigOutHandler.class.getName());
    }

    public EndpointReferenceType getEPR() {
        return this.epr;
    }

    public void setEPR(EndpointReferenceType epr) {
        this.epr = epr;
    }

    @Override
    public void invoke(MessageContext context) throws Exception {
        if (Boolean.TRUE.equals(context.getProperty("client.mode"))) {
            this.invokeClient(context);
        } else {
            super.invoke(context);
        }
    }

    private void invokeClient(MessageContext context) {
        OperationInfo oi = context.getExchange().getOperation();
        AddressingOperationInfo aoi = (AddressingOperationInfo)oi.getProperty("addressingOperationInfo");
        if (aoi == null) {
            return;
        }
        AddressingHeadersFactory factory = (AddressingHeadersFactory)oi.getProperty(AddressingInHandler.ADRESSING_FACTORY.toString());
        if (factory == null) {
            factory = new AddressingHeadersFactory200508();
        }
        AddressingHeaders headers = new AddressingHeaders();
        headers.setTo(aoi.getTo());
        headers.setAction(aoi.getInAction());
        if (this.epr != null) {
            headers.setReferenceParameters(this.makeRefParams(this.epr.getReferenceParameters()));
        }
        headers.setReplyTo(aoi.getReplyTo());
        headers.setFaultTo(aoi.getFaultTo());
        headers.setFrom(aoi.getFrom());
        headers.setMessageID("urn:uuid:" + new RandomGUID().toString());
        context.setId(headers.getMessageID());
        OutMessage msg = (OutMessage)context.getCurrentMessage();
        if (msg != null) {
            factory.writeHeaders(msg.getOrCreateHeader(), headers);
        }
    }

    private List makeRefParams(ReferenceParametersType rp) {
        if (rp == null) {
            return null;
        }
        ArrayList<Element> refParams = new ArrayList<Element>();
        Element rpElement = new DOMBuilder().build((org.w3c.dom.Element)rp.getDomNode());
        if (rpElement != null) {
            List refs = rpElement.getContent();
            for (int i = 0; i < refs.size(); ++i) {
                if (!(refs.get(i) instanceof Element)) continue;
                Element e1 = (Element)refs.get(i);
                e1.setAttribute(new Attribute("IsReferenceParameter", "true", Namespace.getNamespace("wsa", "http://www.w3.org/2005/08/addressing")));
                Element e2 = new Element(e1.getName(), "rpns" + i, e1.getNamespaceURI());
                e2.setAttribute(new Attribute("IsReferenceParameter", "true", Namespace.getNamespace("wsa", "http://www.w3.org/2005/08/addressing")));
                e2.setText(e1.getText());
                refParams.add(e2);
            }
        }
        if (refParams.size() > 0) {
            return refParams;
        }
        return null;
    }

    private static class RandomGUID {
        private String valueBeforeMD5;
        private String valueAfterMD5;
        private static Random myRand = new Random();
        private static String s_id;

        public RandomGUID() {
            MessageDigest md5 = null;
            StringBuffer sbValueBeforeMD5 = new StringBuffer();
            try {
                md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Can't generate MD5 digest.", e);
            }
            try {
                long time = System.currentTimeMillis();
                long rand = myRand.nextLong();
                sbValueBeforeMD5.append(s_id);
                sbValueBeforeMD5.append(":");
                sbValueBeforeMD5.append(Long.toString(time));
                sbValueBeforeMD5.append(":");
                sbValueBeforeMD5.append(Long.toString(rand));
                this.valueBeforeMD5 = sbValueBeforeMD5.toString();
                md5.update(this.valueBeforeMD5.getBytes());
                byte[] array = md5.digest();
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < array.length; ++j) {
                    int b = array[j] & 0xFF;
                    if (b < 16) {
                        sb.append('0');
                    }
                    sb.append(Integer.toHexString(b));
                }
                this.valueAfterMD5 = sb.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            String raw = this.valueAfterMD5.toUpperCase();
            StringBuffer sb = new StringBuffer();
            sb.append(raw.substring(0, 8));
            sb.append("-");
            sb.append(raw.substring(8, 12));
            sb.append("-");
            sb.append(raw.substring(12, 16));
            sb.append("-");
            sb.append(raw.substring(16, 20));
            sb.append("-");
            sb.append(raw.substring(20));
            return sb.toString();
        }

        static {
            try {
                s_id = InetAddress.getLocalHost().toString();
            }
            catch (UnknownHostException uhe) {
                s_id = "127.0.0.1";
            }
        }
    }
}

