/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts.rft;

import de.fzj.unicore.uas.client.ReliableFileTransferClient;
import de.fzj.unicore.uas.fts.rft.AbstractStoreImpl;
import de.fzj.unicore.uas.fts.rft.LocalChunkImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class LocalStoreImpl
extends AbstractStoreImpl {
    private final File baseDir;
    private MessageDigest messageDigest;
    private byte[] digest;
    public static final String DIGEST_ALGORITHM = "SHA1";

    public LocalStoreImpl(File baseDir, String target, long totalLength) {
        super(target, totalLength);
        this.baseDir = baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() throws Exception {
        File file = new File(this.baseDir, this.target);
        try {
            this.messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM, "BC");
        }
        catch (NoSuchAlgorithmException n) {
            throw new RuntimeException(n);
        }
        DigestOutputStream os = new DigestOutputStream(new FileOutputStream(file), this.messageDigest);
        try {
            for (String s : this.getFileNameList()) {
                FileInputStream is = new FileInputStream(new File(this.baseDir, new File(this.partsDir, s).getPath()));
                IOUtils.copy((InputStream)is, (OutputStream)os);
                ((OutputStream)os).flush();
                ((InputStream)is).close();
            }
        }
        finally {
            ((OutputStream)os).close();
            this.digest = this.messageDigest.digest();
        }
        if (file.length() != this.totalLength) {
            throw new IOException("Final size does not match expected size");
        }
    }

    public String getDigest() {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < this.digest.length; ++i) {
            String hex = Integer.toHexString(0xFF & this.digest[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    @Override
    protected boolean checkOK(ReliableFileTransferClient.Chunk chunk) throws Exception {
        File f = new File(this.baseDir, chunk.getPath());
        return f.exists() && f.length() == chunk.getLength();
    }

    @Override
    protected long getActualFileSize(ReliableFileTransferClient.Chunk chunk) throws Exception {
        File f = new File(this.baseDir, chunk.getPath());
        return f.exists() ? f.length() : -1L;
    }

    @Override
    protected ReliableFileTransferClient.Chunk createChunk(int index, String path, long offset, long length) {
        return new LocalChunkImpl(this.baseDir, index, path, offset, length);
    }

    @Override
    protected void createPartsDirIfNotExists() throws Exception {
        File parts = new File(this.baseDir, this.partsDir);
        if (!parts.exists()) {
            parts.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadPropertiesFileIfExists() throws Exception {
        File props = new File(this.baseDir, this.propertiesPath);
        if (props.exists()) {
            FileInputStream is = new FileInputStream(props);
            try {
                this.properties.load(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
    }

    @Override
    protected OutputStream getOutputStream(String path, boolean append) throws IOException {
        return new FileOutputStream(new File(this.baseDir, path), append);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }
}

