/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.JobManagement;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.client.StorageClient;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.math.BigInteger;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.StatusInfoType;
import org.unigrids.services.atomic.types.StatusType;
import org.unigrids.x2006.x04.services.jms.AbortDocument;
import org.unigrids.x2006.x04.services.jms.HoldDocument;
import org.unigrids.x2006.x04.services.jms.JobPropertiesDocument;
import org.unigrids.x2006.x04.services.jms.ResumeDocument;
import org.unigrids.x2006.x04.services.jms.StartDocument;
import org.unigrids.x2006.x04.services.jms.SubmissionTimeDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class JobClient
extends BaseUASClient {
    private static final Logger logger = Log.getLogger("unicore.client", JobClient.class);
    private ResumeDocument resumeDoc;
    private HoldDocument holdDoc;
    private AbortDocument abortDoc;
    private StartDocument startDoc;
    private Calendar submissionTime;
    private Integer exitCode;
    private String statusDescription;
    private final JobManagement jobService = this.makeProxy(JobManagement.class);

    public JobClient(String url, EndpointReferenceType address, IClientConfiguration sec) throws Exception {
        super(url, address, sec);
        this.initDocs();
        this.setRetryDefaults();
    }

    public JobClient(EndpointReferenceType address, IClientConfiguration sec) throws Exception {
        this(address.getAddress().getStringValue(), address, sec);
    }

    private void initDocs() {
        this.holdDoc = HoldDocument.Factory.newInstance();
        this.holdDoc.addNewHold();
        this.abortDoc = AbortDocument.Factory.newInstance();
        this.abortDoc.addNewAbort();
        this.startDoc = StartDocument.Factory.newInstance();
        this.startDoc.addNewStart();
        this.resumeDoc = ResumeDocument.Factory.newInstance();
        this.resumeDoc.addNewResume();
    }

    public JobPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return JobPropertiesDocument.Factory.parse(this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    public StorageClient getUspaceClient() throws Exception {
        EndpointReferenceType epr = this.getResourcePropertiesDocument().getJobProperties().getWorkingDirectoryReference();
        StorageClient storageClient = new StorageClient(epr, this.getSecurityConfiguration());
        return storageClient;
    }

    public void start() throws Exception {
        logger.debug("Calling service at wsaTo: " + this.getEPR().getAddress().getStringValue());
        this.jobService.Start(this.startDoc);
    }

    public void abort() throws Exception {
        logger.debug("Calling service at wsaTo: " + this.getEPR().getAddress().getStringValue());
        this.jobService.Abort(this.abortDoc);
    }

    public void hold() throws Exception {
        logger.debug("Calling service at wsaTo: " + this.getEPR().getAddress().getStringValue());
        this.jobService.Hold(this.holdDoc);
    }

    public void resume() throws Exception {
        logger.debug("Calling service at wsaTo: " + this.getEPR().getAddress().getStringValue());
        this.jobService.Resume(this.resumeDoc);
    }

    public String waitUntilDone(int timeout) throws Exception {
        StatusType.Enum status = StatusType.UNDEFINED;
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        while (timeout <= 0 || elapsed <= (long)timeout) {
            elapsed = System.currentTimeMillis() - start;
            status = this.getStatus();
            if (status.equals(StatusType.SUCCESSFUL)) break;
            if (status.equals(StatusType.FAILED)) {
                throw new Exception("Job failed" + (this.statusDescription != null ? ". The error was: " + this.statusDescription : ""));
            }
            Thread.sleep(500L);
        }
        return status.toString();
    }

    public String waitUntilReady(int timeout) throws Exception {
        StatusType.Enum status = StatusType.UNDEFINED;
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        while (timeout <= 0 || elapsed <= (long)timeout) {
            elapsed = System.currentTimeMillis() - start;
            status = this.getStatus();
            if (status.equals(StatusType.READY)) break;
            if (status.equals(StatusType.FAILED) || status.equals(StatusType.SUCCESSFUL)) {
                throw new Exception("Job is already done, status is <" + status.toString() + ">, error description is <" + this.statusDescription + ">");
            }
            Thread.sleep(500L);
        }
        return status.toString();
    }

    public StatusType.Enum getStatus() throws Exception {
        StatusInfoType s = this.getResourcePropertiesDocument().getJobProperties().getStatusInfo();
        if (s != null) {
            this.statusDescription = s.getDescription();
            return s.getStatus();
        }
        this.statusDescription = "Status is not available";
        return StatusType.UNDEFINED;
    }

    public String getStatusMessage() throws Exception {
        StatusInfoType s = this.getResourcePropertiesDocument().getJobProperties().getStatusInfo();
        this.statusDescription = s.getDescription();
        return s.getDescription();
    }

    public Integer getExitCode() {
        if (this.exitCode == null) {
            try {
                BigInteger eCode;
                StatusInfoType sit = this.getResourcePropertiesDocument().getJobProperties().getStatusInfo();
                if (sit.isSetExitCode() && (eCode = sit.getExitCode()) != null) {
                    this.exitCode = eCode.intValue();
                }
            }
            catch (Exception e) {
                Log.logException("Can't get exit code.", e, logger);
            }
        }
        return this.exitCode;
    }

    public Float getProgress() {
        try {
            if (this.getResourcePropertiesDocument().getJobProperties().getStatusInfo().isSetProgress()) {
                return Float.valueOf(this.getResourcePropertiesDocument().getJobProperties().getStatusInfo().getProgress());
            }
        }
        catch (Exception e) {
            Log.logException("Can't get progress.", e, logger);
        }
        return null;
    }

    public Calendar getSubmissionTime() {
        if (this.submissionTime == null) {
            try {
                this.submissionTime = SubmissionTimeDocument.Factory.parse(this.getResourceProperty(JobManagement.RPSubmissionTime)).getSubmissionTime();
            }
            catch (Exception e) {
                Log.logException("Can't get submission time.", e, logger);
            }
        }
        return this.submissionTime;
    }

    public String getJobLog() throws Exception {
        return this.getResourcePropertiesDocument().getJobProperties().getLog();
    }
}

