from ucfg_updater import *
from ucfg_utils import info, error

from ucfg_main import ConfigUtilities

import os
import re

class UUpdater(UUpdaterBase):
	
	def printDescription(self, options):
		info(options, "Updates UNICORE Gateway component from pre-6.5.0 to 6.5.0 (which released with the base UNICORE 6.6.0)")

	def run(self, options):
		info(options, "UNICORE Gateway updater")
		cfgUtil = ConfigUtilities(options, "gateway")

		
		# gateway.properties
		cfgUtil.updateJavaPropertyNames('gateway.properties', {
			'hostname' 						: 'gateway.hostname',
			'http.connection.chunked' 		: 'gateway.client.chunked',
			'http.socket.timeout' 			: 'gateway.client.socketTimeout',
			'http.connection.timeout' 		: 'gateway.client.connectionTimeout',
			'http.connection.maxTotal' 		: 'gateway.client.maxTotal',
			'http.connection.maxPerService' : 'gateway.client.maxPerService',
			'signConsignorToken' 			: 'gateway.signConsignorToken',
			'consignorTokenTimeTolerance' 	: 'gateway.consignorTokenTimeTolerance',
			'consignorTokenValidity' 		: 'gateway.consignorTokenValidity',
			'registration.enable' 			: 'gateway.registration.enable',
			'registration.deny' 			: 'gateway.registration.deny',
			'registration.allow' 			: 'gateway.registration.allow',
			'jetty.minThreads' 				: 'gateway.httpServer.minThreads',
			'jetty.maxThreads' 				: 'gateway.httpServer.maxThreads',
			'jetty.maxIdleTime' 			: 'gateway.httpServer.maxIdleTime',
			'jetty.lowResourceMaxIdleTime' 	: 'gateway.httpServer.lowResourceMaxIdleTime',
			'jetty.useNIO' 					: 'gateway.httpServer.useNIO',
			'soapMaxHeader' 				: 'gateway.soapMaxHeader'
		})

		cfgUtil.commentJavaProperties('gateway.properties', {
			'jetty.lowThreads' 				: 'This property is not available anymore without a direct replacement. You can check the gateway.httpServer.highLoadConnections property documentation for a close counterpart.'
		});	



		# security.properties
		tsType = cfgUtil.getJavaProperty('security.properties', 'truststoretype')
		tsDir = cfgUtil.getJavaProperty('security.properties', 'truststore')

		toAdd = {}

		cfgUtil.updateJavaPropertyNames('security.properties', {
			'keystore' 						: 'gateway.credential.path',
			'keystorepassword'				: 'gateway.credential.password',
			'truststoretype' 				: 'gateway.truststore.type',
			'truststorepassword'			: 'gateway.truststore.keystorePassword'
		})
		
		if tsType == None or re.search("JKS", tsType, re.I) or re.search("PKCS12", tsType, re.I):
			cfgUtil.updateJavaPropertyNames('security.properties', {
				'truststore' : 'gateway.truststore.keystorePath'
			})
			toAdd['gateway.truststore.type'] = 'keystore'
		elif re.search("file", tsType, re.I):
			info(options, "WARNING! The 'file' type of truststore is not supported anymore. You should switch to a more flexible 'directory' truststore, where each trusted CA certificate can be dropped in in a separate PEM file.")
		elif re.search('directory', tsType, re.I):
			cfgUtil.updateJavaPropertyNames('security.properties', {
				'truststore' : 'gateway.truststore.directoryLocations.1'
			})
			toAdd['gateway.truststore.directoryLocations.1'] = tsDir+'/*.pem'
			toAdd['gateway.truststore.directoryLocations.2'] = tsDir+'/*.cert'
			toAdd['gateway.truststore.type'] ='directory'

		#crlcheck.properties
		crlMode = cfgUtil.getJavaProperty('crlcheck.properties', 'crlcheck.mode')
		interval = cfgUtil.getJavaProperty('crlcheck.properties', 'crlcheck.interval')
		if crlMode == None:
			pass
		elif re.search('NONE', crlMode, re.I):
			toAdd['gateway.truststore.crlMode'] = 'IGNORE';
		elif re.search('LAX', crlMode, re.I):
			toAdd['gateway.truststore.crlMode'] = 'IF_VALID';
		elif re.search('STRICT', crlMode, re.I):
			toAdd['gateway.truststore.crlMode'] = 'REQUIRE';

		if interval != None:
			toAdd['gateway.truststore.crlUpdateInterval'] = interval;
		
		for key in cfgUtil.getJavaPropertyKeys('crlcheck.properties'):
			m = re.search('(.*)\.crl\.url', key)
			if m != None:
				crlDef = cfgUtil.getJavaProperty('crlcheck.properties', key)
				toAdd['gateway.truststore.crlLocations.'+m.group(1)] = crlDef
		 
		cfgUtil.setJavaProperties('security.properties', toAdd)
		
		info(options, "IMPORTANT: The crlcheck.properties file is not used anymore. CRLs configuration is done in security.properties. You can remove this file.")
		
		info(options, "IMPORTANT: Security properties were updated to the new format. Note that you should review the new settings and consider MANY new available options, described in documentation.")
			
		info(options, "Finished update of configuration of UNICORE Gateway")


