/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway.util;

import java.net.URI;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class XURI {
    private final URI uri;
    private URI doubledots = URI.create("..");
    private LinkedList<String> pl;

    public XURI(URI uri) {
        this.uri = uri.normalize();
        this.init();
    }

    public XURI(String uri) {
        this.uri = URI.create(uri).normalize();
        this.init();
    }

    public XURI(XURI u, URI path) {
        this.uri = u.resolve(path.normalize()).getURI();
        this.init();
    }

    public static XURI create(String uri) {
        return new XURI(URI.create(uri));
    }

    private void init() {
        this.pl = new LinkedList();
        StringTokenizer tok = new StringTokenizer(this.getPath(), "/");
        while (tok.hasMoreTokens()) {
            this.pl.add(tok.nextToken());
        }
    }

    public XURI resolve(URI ruri) {
        return new XURI(this.getURI().resolve(ruri));
    }

    public URI getSchemeAndAuthority() {
        return URI.create(this.getURI().getScheme() + "://" + this.getURI().getAuthority());
    }

    public String getPath() {
        return this.getURI().getPath();
    }

    public String getHost() {
        return this.getURI().getHost();
    }

    public int getPort() {
        return this.getURI().getPort();
    }

    public String getScheme() {
        return this.getURI().getScheme();
    }

    public boolean isDirectory() {
        return this.getPath().endsWith("/");
    }

    public XURI ensureIsDirectory() {
        if (this.isDirectory()) {
            return this;
        }
        return new XURI(URI.create(this.getURI() + "/"));
    }

    public XURI getParent() {
        if (this.isDirectory()) {
            return this.resolve(this.doubledots);
        }
        return new XURI(URI.create(this.getURI().toString() + "/")).resolve(this.doubledots);
    }

    public int countPathElements() {
        if (this.pl.size() == 1 && this.pl.getFirst().equals("..")) {
            return -1;
        }
        return this.pl.size();
    }

    public LinkedList<String> getPathElements() {
        return this.pl;
    }

    public String getPathElement(int i) {
        if (this.countPathElements() > i) {
            return this.getPathElements().listIterator(i).next();
        }
        return null;
    }

    public XURI relativize(XURI xuri) {
        return new XURI(this.getURI().relativize(xuri.getURI()));
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.getURI().equals(((XURI)o).getURI());
    }

    public int hashCode() {
        return this.getURI().hashCode();
    }

    public String toString() {
        return this.getURI().toString();
    }
}

