/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway.util;

import eu.unicore.gateway.properties.GatewayProperties;
import eu.unicore.gateway.util.LogUtil;
import eu.unicore.gateway.util.ProtocolPluginHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.bio.SocketEndPoint;
import org.eclipse.jetty.server.BlockingHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;

public class UpgreadableBlockingConnection
extends BlockingHttpConnection {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.gateway", UpgreadableBlockingConnection.class);
    private GatewayProperties props;

    public UpgreadableBlockingConnection(Connector connector, EndPoint endpoint, Server server, GatewayProperties props) {
        super(connector, endpoint, server);
        this.props = props;
    }

    protected void handleRequest() throws IOException {
        super.handleRequest();
        String protocol = this._response.getHeader("Upgrade");
        if (protocol != null) {
            protocol = this._request.getHeader("Upgrade");
            String clazz = "";
            try {
                clazz = this.props.getProtocolPluginHandler(protocol);
                ProtocolPluginHandler handler = (ProtocolPluginHandler)Class.forName(clazz).newInstance();
                handler.configure((HttpServletRequest)this._request);
                OutputStream os = ((SocketEndPoint)this.getEndPoint()).getOutputStream();
                InputStream is = ((SocketEndPoint)this.getEndPoint()).getInputStream();
                try {
                    handler.handle(is, os);
                }
                catch (IOException io) {
                    LogUtil.logException((String)"Error handling custom protocol connection.", (Throwable)io, (Logger)logger);
                }
                this.getConnector().close();
            }
            catch (Exception ex) {
                LogUtil.logException((String)("Error in custom protocol handler <" + clazz + ">"), (Throwable)ex, (Logger)logger);
            }
        }
    }
}

