/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway.util;

import eu.unicore.gateway.util.LogUtil;
import eu.unicore.gateway.util.ProtocolPluginHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.ExpectContinueMethod;

public class UpdateProtocolMethod
extends ExpectContinueMethod {
    private final ProtocolPluginHandler handler;

    public UpdateProtocolMethod(ProtocolPluginHandler handler) {
        this.handler = handler;
    }

    protected void readResponse(HttpState state, HttpConnection conn) throws IOException, HttpException {
        while (this.statusLine == null) {
            this.readStatusLine(state, conn);
            this.processStatusLine(state, conn);
            this.readResponseHeaders(state, conn);
            this.processResponseHeaders(state, conn);
            int status = this.statusLine.getStatusCode();
            if (status == 101) {
                return;
            }
            if (status < 100 || status >= 200) continue;
            this.statusLine = null;
        }
        this.readResponseBody(state, conn);
        this.processResponseBody(state, conn);
    }

    public int execute(HttpState state, HttpConnection conn) throws HttpException, IOException {
        this.addRequestHeader("Upgrade", this.handler.getProtocol());
        this.addRequestHeader("Connection", "keep-alive");
        try {
            int res = super.execute(state, conn);
            if (res != 101) {
                return res;
            }
        }
        catch (Throwable t) {
            LogUtil.logException("Error executing UpdateProtocol", t);
        }
        OutputStream os = conn.getRequestOutputStream();
        InputStream is = conn.getResponseInputStream();
        this.handler.handle(is, os);
        return 200;
    }

    protected boolean hasRequestContent() {
        return false;
    }

    public String getName() {
        return "HEAD";
    }
}

