/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway.util;

import eu.unicore.gateway.util.CharArrayWriterExt;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.CharBuffer;
import org.apache.log4j.Logger;

public class BufferingProxyReader
extends Reader {
    private Reader reader;
    private CharArrayWriterExt buffer;
    private int bufPtr;
    private int markedPos;
    private int maxHeader;
    private Logger log = null;

    public BufferingProxyReader(Reader reader, Logger log, int maxHeader) {
        this.reader = reader;
        this.buffer = new CharArrayWriterExt(10240);
        this.bufPtr = 0;
        this.markedPos = -1;
        if (log != null && log.isTraceEnabled()) {
            this.log = log;
        }
        this.maxHeader = maxHeader;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.buffer == null) {
            int ret = this.reader.read(cbuf, off, len);
            if (this.log != null && ret > 0) {
                this.log.trace((Object)("[INPUT]" + new String(cbuf, off, ret)));
            }
            return ret;
        }
        if (len + this.bufPtr >= this.maxHeader) {
            throw new IOException("Header is too large. Gateway supports up to " + this.maxHeader + "b headers");
        }
        int readChars = this.reader.read(cbuf, off, len);
        this.buffer.write(cbuf, off, readChars);
        this.bufPtr += readChars;
        if (this.log != null && readChars > 0) {
            this.log.trace((Object)("[INPUT]" + new String(cbuf, off, readChars)));
        }
        return readChars;
    }

    public void replay(OutputStream os, int startOffset, int len, String charset) throws IOException {
        String s = new String(this.buffer.getInternalBuffer(), startOffset, len);
        os.write(s.getBytes(charset));
        if (this.log != null) {
            this.log.trace((Object)("[REPLAY]" + s));
        }
    }

    public void replayRest(OutputStream os, int startOffset, String charset) throws IOException {
        int len = this.bufPtr - startOffset;
        if (len > 0) {
            String s = new String(this.buffer.getInternalBuffer(), startOffset, len);
            os.write(s.getBytes(charset));
            if (this.log != null) {
                this.log.trace((Object)("[REPLAY-R]" + s));
            }
        }
        this.buffer = null;
    }

    public void setMarkedPos(int pos) {
        this.markedPos = pos;
    }

    public int getMarkedPos() {
        return this.markedPos;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark is not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        return super.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return super.read(target);
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset is unsupported");
    }

    @Override
    public long skip(long n) throws IOException {
        return this.reader.skip(n);
    }
}

