/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway.soap;

import eu.unicore.gateway.soap.SoapFault;
import eu.unicore.gateway.soap.SoapVersion;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Soap12
implements SoapVersion {
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static Soap12 instance = new Soap12();
    private static final double version = 1.2;
    private static final String namespace = "http://www.w3.org/2003/05/soap-envelope";
    private static final String prefix = "env";
    private static final String noneRole = "http://www.w3.org/2003/05/soap-envelope/role/none";
    private static final String ultimateReceiverRole = "http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver";
    private static final String nextRole = "http://www.w3.org/2003/05/soap-envelope/role/next";
    private static final String soapEncodingStyle = "http://www.w3.org/2003/05/soap-encoding";
    public static final QName envelope = new QName("http://www.w3.org/2003/05/soap-envelope", "Envelope", "env");
    public static final QName header = new QName("http://www.w3.org/2003/05/soap-envelope", "Header", "env");
    public static final QName body = new QName("http://www.w3.org/2003/05/soap-envelope", "Body", "env");
    public static final QName fault = new QName("http://www.w3.org/2003/05/soap-envelope", "Fault", "env");
    private static final Map<SoapFault.FaultCode, String> codes = new HashMap<SoapFault.FaultCode, String>();

    public static Soap12 getInstance() {
        return instance;
    }

    @Override
    public void writeStartElement(XMLStreamWriter out, String localName) throws XMLStreamException {
        out.writeStartElement(prefix, localName, namespace);
    }

    @Override
    public void writeFault(XMLStreamWriter out, SoapFault fault, String hostUri) throws XMLStreamException {
        this.writeStartElement(out, "Fault");
        SoapFault.FaultCode code = fault.getCode();
        this.writeStartElement(out, "Code");
        this.writeStartElement(out, "Value");
        out.writeCharacters("env:" + codes.get((Object)code));
        out.writeEndElement();
        out.writeEndElement();
        String reason = fault.getReason();
        this.writeStartElement(out, "Reason");
        this.writeStartElement(out, "Text");
        out.writeAttribute("xml", XML_NAMESPACE, "lang", "en-US");
        out.writeCharacters(reason);
        out.writeEndElement();
        out.writeEndElement();
        this.writeStartElement(out, "Node");
        out.writeCharacters(hostUri);
        out.writeEndElement();
        this.writeStartElement(out, "Role");
        out.writeCharacters(nextRole);
        out.writeEndElement();
    }

    @Override
    public double getVersion() {
        return 1.2;
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    @Override
    public String getPrefix() {
        return prefix;
    }

    @Override
    public QName getEnvelope() {
        return envelope;
    }

    @Override
    public QName getHeader() {
        return header;
    }

    @Override
    public QName getBody() {
        return body;
    }

    @Override
    public QName getFault() {
        return fault;
    }

    @Override
    public String getSoapEncodingStyle() {
        return soapEncodingStyle;
    }

    @Override
    public String getNoneRole() {
        return noneRole;
    }

    @Override
    public String getUltimateReceiverRole() {
        return ultimateReceiverRole;
    }

    @Override
    public String getNextRole() {
        return nextRole;
    }

    static {
        codes.put(SoapFault.FaultCode.MUST_UNDERSTAND, "MustUnderstand");
        codes.put(SoapFault.FaultCode.VERSION_MISMATCH, "VersionMismatch");
        codes.put(SoapFault.FaultCode.RECEIVER, "Receiver");
        codes.put(SoapFault.FaultCode.SENDER, "Sender");
    }
}

