/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway.properties;

import eu.unicore.gateway.util.LogUtil;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.FilePropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class GatewayProperties
extends FilePropertiesHelper {
    private static final Logger log = LogUtil.getLogger((String)"unicore.configuration", GatewayProperties.class);
    public static final File FILE_GATEWAY_PROPERTIES;
    public static final String KEY_HOSTNAME = "hostname";
    public static final String KEY_CONSIGNORT_TOLERANCE = "consignorTokenTimeTolerance";
    public static final String KEY_CONSIGNORT_VALIDITY = "consignorTokenValidity";
    public static final String KEY_CONSIGNORT_SIGN = "signConsignorToken";
    public static final String KEY_MAX_HEADER = "soapMaxHeader";
    public static final String KEY_EXTERNAL_ADDRESS = "externalHostname";
    public static final String KEY_WEBPAGE_DISABLE = "disableWebpage";
    public static final String KEY_PROTOCOL_PLUGIN_PFX = "protocolPlugin.";
    public static final String KEY_REG_ENABLED = "registration.enable";
    public static final String KEY_REG_INCL = "registration.allow";
    public static final String KEY_REG_EXCL = "registration.deny";
    public static final String KEY_SOCKET_TIMEOUT = "client.socketTimeout";
    public static final String KEY_CHUNKED = "client.chunked";
    public static final String KEY_CONN_TIMEOUT = "client.connectionTimeout";
    public static final String KEY_CONN_KEEPALIVE = "client.keepAlive";
    public static final String KEY_CONN_GZIP = "client.gzip";
    public static final String KEY_PROTO_EXPECTCONTINUE = "client.expectContinue";
    public static final String KEY_CONN_MAX_TOTAL = "client.maxTotal";
    public static final String KEY_CONN_MAX_PERHOST = "client.maxPerService";
    public static final File FILE_JETTY_PROPERTIES;
    @DocumentationReferencePrefix
    public static final String PREFIX = "gateway.";
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> DEFAULTS;
    public static final int DEFAULT_MAX_HDR = 102400;

    public GatewayProperties(String name) throws ConfigurationException, IOException {
        this(new File(name));
    }

    public GatewayProperties(File f) throws ConfigurationException, IOException {
        super(PREFIX, f, DEFAULTS, log);
    }

    public int getSocketTimeout() {
        return this.getIntValue(KEY_SOCKET_TIMEOUT);
    }

    public int getConnectionTimeout() {
        return this.getIntValue(KEY_CONN_TIMEOUT);
    }

    public boolean isKeepAlive() {
        return this.getBooleanValue(KEY_CONN_KEEPALIVE);
    }

    public boolean isGzipEnabled() {
        return this.getBooleanValue(KEY_CONN_GZIP);
    }

    public boolean isExpectContinueEnabled() {
        return this.getBooleanValue(KEY_PROTO_EXPECTCONTINUE);
    }

    public int getMaxTotalConnections() {
        return this.getIntValue(KEY_CONN_MAX_TOTAL);
    }

    public int getMaxPerServiceConnections() {
        return this.getIntValue(KEY_CONN_MAX_PERHOST);
    }

    public String getHostname() {
        return this.getValue(KEY_HOSTNAME);
    }

    public String getExternalHostname() {
        return this.getValue(KEY_EXTERNAL_ADDRESS);
    }

    public int getConsTTol() {
        return this.getIntValue(KEY_CONSIGNORT_TOLERANCE);
    }

    public int getConsTVal() {
        return this.getIntValue(KEY_CONSIGNORT_VALIDITY);
    }

    public boolean isConsTSign() {
        return this.getBooleanValue(KEY_CONSIGNORT_SIGN);
    }

    public boolean isDynamicRegistrationEnabled() {
        return this.getBooleanValue(KEY_REG_ENABLED);
    }

    public boolean isDetailedWebPageDisabled() {
        return this.getBooleanValue(KEY_WEBPAGE_DISABLE);
    }

    public String getProtocolPluginHandler(String name) {
        String pv = this.getValue(KEY_PROTOCOL_PLUGIN_PFX + name.toUpperCase());
        if (pv == null) {
            return "";
        }
        return pv;
    }

    public boolean isChunkedDispatch() {
        return this.getBooleanValue(KEY_CHUNKED);
    }

    public String getRegistrationExcludes() {
        return this.getValue(KEY_REG_EXCL);
    }

    public String getRegistrationIncludes() {
        return this.getValue(KEY_REG_INCL);
    }

    public int getMaxSoapHeader() {
        return this.getIntValue(KEY_MAX_HEADER);
    }

    static {
        FILE_JETTY_PROPERTIES = FILE_GATEWAY_PROPERTIES = new File("conf" + File.separator + "gateway.properties");
        DEFAULTS = new HashMap<String, PropertyMD>();
        PropertyMD.DocumentationCategory consigCat = new PropertyMD.DocumentationCategory("Passing Consignor info", "1");
        PropertyMD.DocumentationCategory cliCat = new PropertyMD.DocumentationCategory("Gateway -> Site client", "2");
        PropertyMD.DocumentationCategory advCat = new PropertyMD.DocumentationCategory("Advanced", "3");
        DEFAULTS.put(KEY_HOSTNAME, new PropertyMD().setMandatory().setDescription("external gateway bind address"));
        DEFAULTS.put(KEY_REG_ENABLED, new PropertyMD("false").setDescription("Whether dynamic registration of sites is enabled."));
        DEFAULTS.put(KEY_REG_EXCL, new PropertyMD().setDescription("Space separated list of denied hosts for dynamic registration."));
        DEFAULTS.put(KEY_REG_INCL, new PropertyMD().setDescription("Space separated list of allowed hosts for dynamic registration."));
        DEFAULTS.put(KEY_WEBPAGE_DISABLE, new PropertyMD("false").setCategory(advCat).setDescription("Whether the (so called monkey) status web page should be disabled."));
        DEFAULTS.put(KEY_EXTERNAL_ADDRESS, new PropertyMD((String)null).setCategory(advCat).setDescription("External address of the gateway, when it is accessible through a frontend server as Apache HTTP."));
        DEFAULTS.put(KEY_MAX_HEADER, new PropertyMD("102400").setBounds(1024L, 1024000000L).setCategory(advCat).setDescription("Size in bytes of the accepted SOAP header. In the most cases you don't need to change it."));
        DEFAULTS.put(KEY_PROTOCOL_PLUGIN_PFX, new PropertyMD((String)null).setList(false).setCategory(advCat).setDescription("Subkey of this property should be a protocol name in capital letters and value should contain the cless of a plugin implementing it."));
        DEFAULTS.put(KEY_CONN_MAX_PERHOST, new PropertyMD("20").setCategory(cliCat).setDescription("Maximum allowed number of connections per backend site."));
        DEFAULTS.put(KEY_CONN_MAX_TOTAL, new PropertyMD("100").setCategory(cliCat).setDescription("Maximum total number of connections to backend sites allowed."));
        DEFAULTS.put(KEY_CHUNKED, new PropertyMD("true").setCategory(cliCat).setDescription("Controls whether chunked passing of HTTP requests to backend sites is supported."));
        DEFAULTS.put(KEY_CONN_GZIP, new PropertyMD("true").setCategory(cliCat).setDescription("Controls whether support for compression is announced to backend sites."));
        DEFAULTS.put(KEY_CONN_KEEPALIVE, new PropertyMD("true").setCategory(cliCat).setDescription("Whether to keep alive the connections to backend sites."));
        DEFAULTS.put(KEY_CONN_TIMEOUT, new PropertyMD("30000").setCategory(cliCat).setDescription("Connection timeout, used when connecting to backend sites."));
        DEFAULTS.put(KEY_SOCKET_TIMEOUT, new PropertyMD("30000").setCategory(cliCat).setDescription("Connection timeout, used when connecting to backend sites."));
        DEFAULTS.put(KEY_PROTO_EXPECTCONTINUE, new PropertyMD("true").setCategory(cliCat).setDescription("Controls whether the HTTP expec-continue mechanism is enaled on connections to backend sites."));
        DEFAULTS.put(KEY_CONSIGNORT_SIGN, new PropertyMD("false").setCategory(consigCat).setDescription("Controls whether information about the authenticated client (the consignor) passed to backend sites should be signed, or not. Signing is slower, but is required when sites may be reached directly, bypassing the Gateway."));
        DEFAULTS.put(KEY_CONSIGNORT_TOLERANCE, new PropertyMD("30").setNonNegative().setCategory(consigCat).setDescription("The validity time of the authenticated client information passed to backend sites will start that many seconds before the real authentication. It is used to mask time synchronization problems between machines."));
        DEFAULTS.put(KEY_CONSIGNORT_VALIDITY, new PropertyMD("60").setPositive().setCategory(consigCat).setDescription("What is the validity time of the authenticated client information passed to backend sites. Increase it if there machines clocks are not synhronized."));
        DEFAULTS.put("httpServer.", new PropertyMD().setCanHaveSubkeys().setHidden().setDescription("Properties with this prefix are used to configure advanced Gateway's Jetty HTTP server settings. See separate documentation."));
    }
}

