/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway.cluster;

import eu.unicore.gateway.VSite;
import eu.unicore.gateway.cluster.MultiSite;
import eu.unicore.gateway.cluster.SelectionStrategy;
import eu.unicore.gateway.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public class RoundRobin
implements SelectionStrategy {
    private static final Logger log = LogUtil.getLogger((String)"unicore.gateway", RoundRobin.class);
    private MultiSite parent;
    private long lastChecked = -1L;
    List<VSite> sitesUp = new ArrayList<VSite>();
    private int interval = 5000;
    final Map<String, Boolean> health = new HashMap<String, Boolean>();
    final Random random = new Random();

    @Override
    public void init(MultiSite parent, Map<String, String> params) {
        this.parent = parent;
        String intervalS = params.get("strategy.healthcheck.interval");
        if (intervalS != null) {
            this.interval = Integer.parseInt(intervalS);
            log.debug((Object)("Health check interval: " + this.interval + " millis."));
        }
    }

    @Override
    public VSite select(String clientID) {
        this.checkHealth();
        int size = this.sitesUp.size();
        if (size == 0) {
            return null;
        }
        int selected = this.random.nextInt(size);
        return this.sitesUp.get(selected);
    }

    protected synchronized void checkHealth() {
        List<VSite> sites = this.parent.getConfiguredSites();
        if (this.lastChecked + (long)this.interval < System.currentTimeMillis()) {
            HashMap<String, Boolean> newHealth = new HashMap<String, Boolean>();
            ArrayList<VSite> up = new ArrayList<VSite>();
            this.lastChecked = System.currentTimeMillis();
            for (VSite v : sites) {
                boolean oldState;
                String key = v.getRealURI().toString();
                boolean newState = v.ping();
                Boolean oldStateB = this.health.get(key);
                boolean bl = oldState = oldStateB == null ? false : oldStateB;
                if (newState != oldState) {
                    String state = newState ? "UP" : "DOWN";
                    log.info((Object)("Vsite " + this.parent.getName() + " node <" + key + "> is " + state));
                }
                newHealth.put(key, newState);
                if (!newState) continue;
                up.add(v);
            }
            this.sitesUp = up;
            this.health.clear();
            this.health.putAll(newHealth);
            return;
        }
    }
}

