/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway.cluster;

import eu.unicore.gateway.VSite;
import eu.unicore.gateway.cluster.MultiSite;
import eu.unicore.gateway.cluster.SelectionStrategy;
import eu.unicore.gateway.util.LogUtil;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PrimaryWithFallBack
implements SelectionStrategy {
    private static final Logger log = LogUtil.getLogger((String)"unicore.gateway", PrimaryWithFallBack.class);
    private long lastChecked = -1L;
    private int interval = 5000;
    private VSite primary;
    private VSite secondary;
    private boolean primaryDown;
    private MultiSite parent;

    @Override
    public void init(MultiSite parent, Map<String, String> params) {
        this.parent = parent;
        String intervalS = params.get("strategy.healthcheck.interval");
        if (intervalS != null) {
            this.interval = Integer.parseInt(intervalS);
            log.debug((Object)("Health check interval: " + this.interval + " millis."));
        }
    }

    @Override
    public VSite select(String clientID) {
        List<VSite> sites = this.parent.getConfiguredSites();
        if (this.primary == null) {
            this.primary = sites.get(0);
        }
        if (this.secondary == null && sites.size() > 1) {
            this.secondary = sites.get(1);
        }
        this.checkHealth();
        return this.primaryDown ? this.secondary : this.primary;
    }

    protected void checkHealth() {
        if (this.lastChecked + (long)this.interval < System.currentTimeMillis()) {
            boolean newState;
            this.lastChecked = System.currentTimeMillis();
            boolean bl = newState = !this.primary.ping();
            if (newState != this.primaryDown) {
                String state = newState ? "DOWN" : "UP";
                log.info((Object)("Primary node of <" + this.parent.getName() + "> is " + state));
            }
            this.primaryDown = newState;
            return;
        }
    }
}

