/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway.cluster;

import eu.unicore.gateway.Site;
import eu.unicore.gateway.VSite;
import eu.unicore.gateway.cluster.PrimaryWithFallBack;
import eu.unicore.gateway.cluster.RoundRobin;
import eu.unicore.gateway.cluster.SelectionStrategy;
import eu.unicore.gateway.util.LogUtil;
import eu.unicore.gateway.util.XURI;
import eu.unicore.security.canl.AuthnAndTrustProperties;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public class MultiSite
implements Site {
    private static final Logger log = LogUtil.getLogger((String)"unicore.gateway", MultiSite.class);
    private final String name;
    private final URI gatewayURI;
    private final URI virtualURI;
    private final int index;
    private final AuthnAndTrustProperties securityCfg;
    private int numberOfRequests = 0;
    private final Map<String, String> params;
    private final List<VSite> configuredSites;
    private SelectionStrategy selectionStrategy;

    public MultiSite(URI gatewayURI, String name, String desc, AuthnAndTrustProperties securityCfg) throws UnknownHostException, URISyntaxException, IOException {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Site needs a name.");
        }
        this.name = name;
        this.gatewayURI = gatewayURI;
        this.virtualURI = new URI(gatewayURI + "/" + name);
        this.index = new XURI(gatewayURI).countPathElements();
        this.securityCfg = securityCfg;
        log.info((Object)("new multi-site: " + this.virtualURI.toString()));
        this.params = new HashMap<String, String>();
        this.configuredSites = new CopyOnWriteArrayList<VSite>();
        this.parseDescription(desc);
        this.configureSites();
        this.configureSelectionStrategy();
    }

    @Override
    public boolean accept(String uri) {
        try {
            boolean decision;
            XURI xuri = new XURI(new URI(uri));
            String sitename = xuri.getPathElement(this.index);
            boolean bl = decision = sitename != null && sitename.equalsIgnoreCase(this.getName());
            if (log.isTraceEnabled()) {
                log.trace((Object)("is " + uri + " a correct URI for this (" + this.toString() + ")Vsite ? " + decision));
            }
            if (decision) {
                ++this.numberOfRequests;
            }
            return decision;
        }
        catch (URISyntaxException e) {
            LogUtil.logException("cannot parse the uri, " + uri + ". this must happen before attempting to map to a registered vsite", e);
            return false;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumberOfRequests() {
        return this.numberOfRequests;
    }

    @Override
    public String getStatusMessage() {
        int OK = 0;
        for (VSite v : this.configuredSites) {
            if (!v.ping()) continue;
            ++OK;
        }
        if (OK > 0) {
            return "OK (" + OK + "/" + this.configuredSites.size() + " nodes online)";
        }
        return "Site is down: 0/" + this.configuredSites.size() + " nodes online";
    }

    @Override
    public boolean ping() {
        return this.ping(2000);
    }

    @Override
    public boolean ping(int timeout) {
        boolean OK = false;
        for (VSite v : this.configuredSites) {
            if (!v.ping(timeout)) continue;
            OK = true;
            break;
        }
        return OK;
    }

    @Override
    public VSite select(String clientID) {
        return this.selectionStrategy.select(clientID);
    }

    public List<VSite> getConfiguredSites() {
        return this.configuredSites;
    }

    public SelectionStrategy getSelectionStrategy() {
        return this.selectionStrategy;
    }

    public void setSelectionStrategy(SelectionStrategy selectionStrategy) {
        this.selectionStrategy = selectionStrategy;
    }

    public void registerVsite(URI address) throws URISyntaxException, UnknownHostException {
        for (VSite v : this.configuredSites) {
            if (!v.getRealURI().equals(address)) continue;
            return;
        }
        VSite v = new VSite(this.gatewayURI, this.name, address.toString(), this.securityCfg);
        this.registerVsite(v);
    }

    public void registerVsite(VSite vsite) {
        this.configuredSites.add(vsite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseDescription(String description) throws IOException {
        String key;
        String[] elements;
        if (description == null) {
            return;
        }
        String desc = description.replace("multisite:", "");
        for (String e : elements = desc.split("\\s*;\\s*")) {
            String[] param = e.trim().split("\\s*=\\s*");
            if (param.length != 2) {
                throw new IllegalArgumentException("Invalid parameter specification: " + e + ". Expected format: key=value");
            }
            key = param[0].toLowerCase();
            String value = param[1].trim();
            this.params.put(key, value);
        }
        String configFile = this.params.get("config");
        if (configFile != null) {
            Properties fileProperties = new Properties();
            FileInputStream istream = new FileInputStream(configFile);
            try {
                fileProperties.load(istream);
            }
            finally {
                istream.close();
            }
            for (Object keyObj : fileProperties.keySet()) {
                key = String.valueOf(keyObj);
                this.params.put(String.valueOf(key), fileProperties.getProperty(key));
            }
        }
    }

    protected void configureSites() throws URISyntaxException, UnknownHostException {
        String[] vsites;
        String siteDesc = this.params.get("vsites");
        if (siteDesc == null) {
            log.info((Object)("No VSites configured for site <" + this.getName() + ">"));
            return;
        }
        for (String vsite : vsites = siteDesc.split("\\s+")) {
            VSite v = new VSite(this.gatewayURI, this.name, vsite, this.securityCfg);
            this.configuredSites.add(v);
            log.info((Object)("Configured vsite " + vsite + " for <" + this.getName() + ">"));
        }
    }

    protected void configureSelectionStrategy() {
        String strategyDesc = this.params.get("strategy");
        if (strategyDesc != null) {
            if ("primaryWithFallback".equals(strategyDesc)) {
                this.selectionStrategy = new PrimaryWithFallBack();
            } else if ("roundRobin".equals(strategyDesc)) {
                this.selectionStrategy = new RoundRobin();
            } else {
                try {
                    Class<?> clazz = Class.forName(strategyDesc);
                    this.selectionStrategy = (SelectionStrategy)clazz.newInstance();
                    log.info((Object)("Configured selection strategy <" + strategyDesc + ">"));
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        } else {
            this.selectionStrategy = new PrimaryWithFallBack();
            log.info((Object)("Using default selection strategy <" + PrimaryWithFallBack.class.getName() + ">"));
        }
        this.selectionStrategy.init(this, this.getParams());
    }

    Map<String, String> getParams() {
        return this.params;
    }
}

