/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway.client;

import eu.unicore.gateway.properties.GatewayProperties;
import eu.unicore.security.canl.IAuthnAndTrustConfiguration;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.HttpUtils;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;

public class HttpClientFactory {
    private static final Logger log = Log.getLogger((String)"unicore.gateway", HttpClientFactory.class);
    private boolean keepAlive;
    private boolean useExpectContinue;
    private boolean enableGzip;
    private boolean chunked;
    private Properties clientProperties = new Properties();
    private DefaultClientConfiguration clientCfg;

    public HttpClientFactory(IAuthnAndTrustConfiguration securityprops, GatewayProperties props) throws Exception {
        this.clientProperties.setProperty("http.connection.timeout", "" + props.getConnectionTimeout());
        this.clientProperties.setProperty("http.socket.timeout", "" + props.getSocketTimeout());
        this.clientProperties.setProperty("http.connection-manager.max-per-host", "" + props.getMaxPerServiceConnections());
        this.clientProperties.setProperty("http.connection-manager.max-total", "" + props.getMaxTotalConnections());
        this.clientCfg = new DefaultClientConfiguration(securityprops.getValidator(), securityprops.getCredential());
        boolean sslEnabled = securityprops.getValidator() != null;
        this.clientCfg.setSslEnabled(sslEnabled);
        this.clientCfg.setSslAuthn(sslEnabled && securityprops.getCredential() != null);
        this.clientCfg.setExtraSettings(this.clientProperties);
        this.keepAlive = props.isKeepAlive();
        this.enableGzip = props.isGzipEnabled();
        this.chunked = props.isChunkedDispatch();
        this.useExpectContinue = props.isExpectContinueEnabled();
        log.debug((Object)("Configured Gateway's client factory: [ssl=" + this.clientCfg.isSslEnabled() + " sslAuthn=" + this.clientCfg.doSSLAuthn() + "]"));
    }

    public HttpClient makeHttpClient(URL url) throws Exception {
        HttpClient client;
        if (url.getProtocol().toLowerCase().equals("https")) {
            log.debug((Object)"Creating TLS client");
            client = HttpUtils.createClient((String)url.toString(), (IClientConfiguration)this.clientCfg);
        } else {
            log.debug((Object)"Creating plain client");
            client = HttpUtils.createClient((Properties)this.clientProperties);
        }
        client.getParams().setParameter("http.protocol.expect-continue", (Object)this.useExpectContinue);
        client.getHostConfiguration().setHost(url.getHost(), url.getPort(), url.getProtocol());
        return client;
    }

    public PostMethod makePostMethod(String path, RequestEntity requestentity) {
        PostMethod post = new PostMethod(path);
        post.setRequestEntity(requestentity);
        if (this.enableGzip) {
            post.setRequestHeader("Accept-Encoding", "gzip");
        }
        if (!this.keepAlive) {
            post.setRequestHeader("Connection", "close");
        }
        post.setContentChunked(this.chunked);
        return post;
    }
}

