/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway.base;

import eu.unicore.gateway.Gateway;
import eu.unicore.gateway.POSTHandler;
import eu.unicore.gateway.SiteOrganiser;
import eu.unicore.gateway.VSite;
import eu.unicore.gateway.base.RawMessageExchange;
import eu.unicore.gateway.client.HttpClientFactory;
import eu.unicore.gateway.properties.GatewayProperties;
import eu.unicore.gateway.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class Servlet
extends HttpServlet {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LogUtil.getLogger((String)"unicore.gateway", Servlet.class);
    private GatewayProperties properties;
    private Gateway gateway;
    private final HttpClientFactory clientFactory;

    public Servlet(Gateway gw) {
        this.gateway = gw;
        this.properties = gw.getProperties();
        this.clientFactory = this.gateway.getClientFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String clientIP = req.getRemoteAddr();
        String clientName = null;
        try {
            X509Certificate[] certPath = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
            if (certPath != null) {
                clientName = certPath[0].getSubjectDN().getName();
            }
        }
        catch (Exception ex) {
            LogUtil.logException((String)"Error getting client information.", (Throwable)ex, (Logger)logger);
        }
        MDC.put((String)"clientIP", (Object)clientIP);
        if (clientName != null) {
            MDC.put((String)"clientName", (Object)clientName);
        }
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Processing request from ").append(clientIP);
            if (clientName != null) {
                sb.append(" Client name: ").append(clientName);
            }
            logger.debug((Object)sb.toString());
        }
        try {
            super.service(req, res);
        }
        finally {
            MDC.remove((String)"clientName");
            MDC.remove((String)"clientIP");
        }
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.debug((Object)"Processing HEAD request");
        String update = req.getHeader("Upgrade");
        if (update != null) {
            logger.debug((Object)("Switching protocols to: " + update));
            this.doProtocolSwitch(update, resp);
            return;
        }
        super.doHead(req, resp);
    }

    protected void doProtocolSwitch(String protocol, HttpServletResponse resp) throws IOException {
        String clazz = this.properties.getProtocolPluginHandler(protocol);
        if (clazz.equals("")) {
            String msg = "Requested protocol <" + protocol + "> is not supported";
            logger.warn((Object)msg);
            resp.sendError(500, msg);
            return;
        }
        try {
            Class.forName(clazz).newInstance();
            resp.setHeader("Upgrade", "protocol");
            resp.setStatus(101);
            resp.flushBuffer();
        }
        catch (Exception e) {
            String msg = "Plugin class for requested protocol <" + protocol + "> not found";
            LogUtil.logException((String)msg, (Throwable)e, (Logger)logger);
            resp.sendError(500, msg);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        SiteOrganiser so = this.gateway.getSiteOrganiser();
        String url = this.fullRequestURL(req);
        this.debugRequest("GET", req, url);
        String clientIP = req.getRemoteAddr();
        VSite vsite = so.match(url, clientIP);
        if (vsite != null) {
            this.doForwardGETtoVSite(vsite, url, req, res, clientIP);
            return;
        }
        URL u = new URL(url);
        if (!"/".equals(u.getPath())) {
            res.sendError(404, "Could not find the requested resource.");
            return;
        }
        this.doGETDefaultGWPage(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doForwardGETtoVSite(VSite vsite, String url, HttpServletRequest req, HttpServletResponse res, String clientIP) throws ServletException, IOException {
        ServletOutputStream os = res.getOutputStream();
        URI u = URI.create(vsite.resolve(url));
        GetMethod get = new GetMethod(u.getPath());
        get.setQueryString(req.getQueryString());
        this.copyHeaders(req, (HttpMethod)get);
        try {
            int r;
            logger.debug((Object)("Forwarding <" + url + "> to <" + u.toString() + ">"));
            HttpClient client = this.clientFactory.makeHttpClient(u.toURL());
            client.executeMethod((HttpMethod)get);
            int result = get.getStatusCode();
            if (result < 200 || result > 299) {
                res.sendError(result, get.getStatusText());
                return;
            }
            res.setStatus(result);
            InputStream is = get.getResponseBodyAsStream();
            byte[] buf = new byte[1024];
            while ((r = is.read(buf)) != -1) {
                os.write(buf, 0, r);
            }
            if (get.getResponseHeader("content-type") != null) {
                res.setContentType(get.getResponseHeader("content-type").getValue());
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)"Error performing GET request.", (Throwable)e, (Logger)logger);
            res.sendError(500, "Could not perform request.");
        }
        finally {
            try {
                get.releaseConnection();
            }
            catch (Exception e) {}
        }
        os.flush();
    }

    private void copyHeaders(HttpServletRequest req, HttpMethod method) {
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if ("Host".equalsIgnoreCase(name)) continue;
            String value = req.getHeader(name);
            method.addRequestHeader(name, value);
        }
    }

    private void doGETDefaultGWPage(HttpServletRequest req, HttpServletResponse res) throws IOException {
        SiteOrganiser so = this.gateway.getSiteOrganiser();
        PrintWriter out = res.getWriter();
        res.setContentType("text/html");
        X509Certificate[] certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
        out.println("<html><link rel='stylesheet' type='text/css' href='resources/gateway.css'/><title>UNICORE 6 Gateway</title><body>");
        String top = "<div id='header'><a href='http://www.unicore.eu'><img src='resources/unicore_logo.gif' border='0'/></a><br/> Gateway <br/>";
        if (certs != null) {
            top = top + "<p class='username'>You are authenticated as: <br/>" + certs[0].getSubjectDN() + "</p>";
        }
        top = top + "</div>";
        out.println(this.getContentDiv(top));
        out.println("<br/>");
        if (!this.properties.isDetailedWebPageDisabled()) {
            out.println(this.getContentDiv(so.toHTMLString()));
        } else {
            out.println(this.getContentDiv("<br/>Detailed site listing disabled.<br/>"));
        }
        out.println("<br/>");
        out.println(this.getFooter());
        out.println("</html></body>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        SiteOrganiser so = this.gateway.getSiteOrganiser();
        String url = this.fullRequestURL(req);
        String clientIP = req.getRemoteAddr();
        this.debugRequest("PUT", req, url);
        VSite vsite = so.match(url, clientIP);
        if (vsite != null) {
            URI u = URI.create(vsite.resolve(url));
            PutMethod put = new PutMethod(u.getPath());
            put.setQueryString(req.getQueryString());
            put.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)req.getInputStream()));
            put.setContentChunked(true);
            this.copyHeaders(req, (HttpMethod)put);
            try {
                logger.debug((Object)("Forwarding <" + url + "> to <" + u.toString() + ">"));
                HttpClient client = this.clientFactory.makeHttpClient(u.toURL());
                client.executeMethod((HttpMethod)put);
                int result = put.getStatusCode();
                if (result < 200 || result > 299) {
                    res.sendError(result, put.getStatusText());
                    return;
                }
                res.setStatus(result);
                InputStream is = put.getResponseBodyAsStream();
                if (is != null) {
                    int r;
                    ServletOutputStream bos = res.getOutputStream();
                    byte[] buf = new byte[1024];
                    while ((r = is.read(buf)) != -1) {
                        bos.write(buf, 0, r);
                    }
                    bos.flush();
                    if (put.getResponseHeader("content-type") != null) {
                        res.setContentType(put.getResponseHeader("content-type").getValue());
                    }
                }
            }
            catch (Exception e) {
                LogUtil.logException((String)"Error performing PUT request.", (Throwable)e, (Logger)logger);
                res.sendError(500, "Could not perform request.");
            }
            finally {
                try {
                    put.releaseConnection();
                }
                catch (Exception e) {}
            }
            return;
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        URL url = new URL(this.fullRequestURL(req));
        this.debugRequest("POST", req, url.toString());
        try {
            if ("/VSITE_REGISTRATION_REQUEST".equals(url.getPath())) {
                this.handleRegistration(req, res);
            } else {
                int maxHeaderSize = this.properties.getMaxSoapHeader();
                RawMessageExchange exchange = new RawMessageExchange(req.getReader(), res.getWriter(), maxHeaderSize);
                String contentType = req.getHeader("Content-type");
                exchange.setProperty("Content-type", contentType);
                if (contentType != null) {
                    if (contentType.contains("application/soap+xml")) {
                        res.setContentType("application/soap+xml; charset=UTF-8");
                    } else if (contentType.contains("application")) {
                        res.setContentType("application/xml; charset=UTF-8");
                    } else {
                        res.setContentType("text/xml; charset=UTF-8");
                    }
                } else {
                    res.setContentType("text/xml; charset=UTF-8");
                }
                X509Certificate[] certPath = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
                if (certPath != null) {
                    exchange.setProperty("cert", certPath);
                }
                exchange.setProperty("peer", req.getRemoteAddr());
                exchange.setRequestURL(url.toString());
                exchange.setProperty("soapaction", req.getHeader("SOAPAction"));
                POSTHandler handler = new POSTHandler(this.gateway.getSiteOrganiser(), this.gateway.getConsignorProducer(), this.clientFactory, this.properties.isChunkedDispatch(), this.gateway.getHostURI().toString());
                handler.invoke(exchange);
                res.flushBuffer();
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)"Failed to process POST request", (Throwable)e, (Logger)logger);
            throw new ServletException("Failed to process POST request: " + e, (Throwable)e);
        }
    }

    protected void handleRegistration(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.properties.isDynamicRegistrationEnabled()) {
            res.sendError(403, "Dynamic registration is disabled.");
        } else {
            String name = req.getParameter("name");
            String address = req.getParameter("address");
            boolean success = true;
            try {
                URI uri = new URI(address);
                success = this.gateway.getDynamicSiteOrganiser().register(name, uri);
                if (success) {
                    PrintWriter pw = res.getWriter();
                    pw.write("<html><body>Your request was processed successfully. <br/>Please click <a href='/'>here</a> to return to the main gateway page.");
                    res.setStatus(201);
                }
            }
            catch (Exception e) {
                LogUtil.logException((String)("Error on registration of [name=" + name + " address=" + address + "]"), (Throwable)e, (Logger)logger);
            }
            if (!success) {
                res.sendError(400, "Registration could not be processed.");
            }
        }
        res.flushBuffer();
    }

    private String fullRequestURL(HttpServletRequest req) {
        String query = req.getQueryString();
        StringBuffer requestURL = req.getRequestURL();
        if (query != null) {
            requestURL.append("?");
            requestURL.append(query);
        }
        return requestURL.toString();
    }

    private String getContentDiv(String content) {
        String s = "<div id='content'><b class='rtop'><b class='r1'></b><b class='r2'></b> <b class='r3'></b> <b class='r4'></b></b>" + content + "<b class=<'rbottom'><b class='r4'></b> <b class='r3'></b> <b class='r2'></b> <b class='r1'></b></b></div>";
        return s;
    }

    private String getFooter() {
        StringBuilder sb = new StringBuilder();
        sb.append("<div id='footer'><hr/> Version: " + Gateway.RELEASE_VERSION + " Up since: ").append(this.gateway.upSince());
        if (this.properties.isDynamicRegistrationEnabled()) {
            sb.append("&nbsp;&nbsp;&nbsp;&nbsp;<a href='resources/register.html'>register a site</a>");
        }
        sb.append("</div>");
        return sb.toString();
    }

    private void debugRequest(String type, HttpServletRequest req, String url) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        logger.debug((Object)("New " + type + " message to " + url));
        if (!logger.isTraceEnabled()) {
            return;
        }
        Enumeration hdrNames = req.getHeaderNames();
        StringBuilder hdrDump = new StringBuilder();
        while (hdrNames.hasMoreElements()) {
            String n = (String)hdrNames.nextElement();
            hdrDump.append(n + ": " + req.getHeader(n) + "\n");
        }
        logger.trace((Object)(type + " request header:\n" + hdrDump));
    }
}

