/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway.base;

import eu.unicore.gateway.soap.SoapVersion;
import eu.unicore.gateway.util.BufferingProxyReader;
import eu.unicore.gateway.util.LogUtil;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLInputFactory2;

public class RawMessageExchange {
    public static final String X509 = "cert";
    public static final String REMOTE_IP = "peer";
    public static final String SOAP_ACTION = "soapaction";
    public static final String CONTENT_TYPE = "Content-type";
    private BufferingProxyReader reader;
    private Writer writer;
    private boolean headerPresent;
    private XMLEventReader eventReader;
    private String requestUrl;
    private String wsaToAddress;
    private String wsaAction;
    private SoapVersion soapVersion;
    private Map<String, Object> parameterMap = new HashMap<String, Object>();
    private String destination;
    private static XMLInputFactory inFact = XMLInputFactory2.newInstance();

    public RawMessageExchange(Reader r, Writer w, int maxHeader) throws XMLStreamException {
        this.reader = new BufferingProxyReader(r, LogUtil.getLogger((String)"gateway.trafficdump", RawMessageExchange.class), maxHeader);
        this.writer = w;
        this.setHeaderPresent(false);
        this.eventReader = inFact.createXMLEventReader(this.reader);
    }

    public Object getProperty(String key) {
        return this.parameterMap.get(key);
    }

    public void setProperty(String key, Object value) {
        this.parameterMap.put(key, value);
    }

    public String getRequestURL() {
        return this.requestUrl;
    }

    public void setRequestURL(String requesturl) {
        this.requestUrl = requesturl;
    }

    public Map<String, Object> getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(Map<String, Object> parametermap) {
        this.parameterMap = parametermap;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public QName getSOAPHeaderName() {
        return this.getSoapVersion().getHeader();
    }

    public QName getSOAPFaultName() {
        return this.getSoapVersion().getFault();
    }

    public SoapVersion getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(SoapVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    public String getWsaToAddress() {
        return this.wsaToAddress;
    }

    public void setWsaToAddress(String wsaToAddress) {
        this.wsaToAddress = wsaToAddress;
    }

    public String getWsaAction() {
        return this.wsaAction;
    }

    public void setWsaAction(String wsaAction) {
        this.wsaAction = wsaAction;
    }

    public XMLEventReader getEventReader() {
        return this.eventReader;
    }

    public BufferingProxyReader getReader() {
        return this.reader;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setHeaderPresent(boolean headerPresent) {
        this.headerPresent = headerPresent;
    }

    public boolean isHeaderPresent() {
        return this.headerPresent;
    }
}

