/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway.base;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.unicore.gateway.Gateway;
import eu.unicore.gateway.base.GatewayNIOSSLSocketConnector;
import eu.unicore.gateway.base.GatewayNioSocketConnector;
import eu.unicore.gateway.base.GatewaySocketConnector;
import eu.unicore.gateway.base.GatewaySslSocketConnector;
import eu.unicore.gateway.base.Servlet;
import eu.unicore.gateway.properties.GatewayProperties;
import eu.unicore.gateway.util.LogUtil;
import eu.unicore.security.canl.IAuthnAndTrustConfiguration;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.jetty.HttpServerProperties;
import eu.unicore.util.jetty.JettyServerBase;
import java.net.URL;
import org.apache.log4j.Logger;
import org.eclipse.jetty.ajp.Ajp13SocketConnector;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class GatewayJettyServer
extends JettyServerBase {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.gateway", GatewayJettyServer.class);
    private GatewayProperties gatewayProperties;
    private Gateway gateway;

    public GatewayJettyServer(Gateway gateway) throws Exception {
        super(new URL(gateway.getProperties().getHostname()), (IAuthnAndTrustConfiguration)gateway.getSecurityProperties(), (HttpServerProperties)gateway.getJettyProperties());
        this.gateway = gateway;
        this.gatewayProperties = gateway.getProperties();
        this.initServer();
    }

    protected AbstractConnector createConnector(URL url) throws ConfigurationException {
        if (this.extraSettings.getBooleanValue("ajp").booleanValue()) {
            return this.createAJPConnector(url);
        }
        return super.createConnector(url);
    }

    protected SslSelectChannelConnector getNioSecuredConnectorInstance() {
        GatewayNIOSSLSocketConnector ssl;
        try {
            ssl = new GatewayNIOSSLSocketConnector(this.gatewayProperties, (X509CertChainValidator)this.securityConfiguration.getValidator(), this.securityConfiguration.getCredential());
        }
        catch (Exception e) {
            throw new RuntimeException("Can not create Jetty NIO SSL connector, shouldn't happen.", e);
        }
        ssl.setLowResourcesConnections(this.extraSettings.getIntValue("highLoadConnections"));
        return ssl;
    }

    protected SslSocketConnector getClassicSecuredConnectorInstance() {
        try {
            return new GatewaySslSocketConnector(this.gatewayProperties, (X509CertChainValidator)this.securityConfiguration.getValidator(), this.securityConfiguration.getCredential());
        }
        catch (Exception e) {
            throw new RuntimeException("Can not create Jetty SSL connector, shouldn't happen.", e);
        }
    }

    protected SelectChannelConnector getNioPlainConnectorInstance() {
        return new GatewayNioSocketConnector(this.gatewayProperties);
    }

    protected SocketConnector getClassicPlainConnectorInstance() {
        return new GatewaySocketConnector(this.gatewayProperties);
    }

    protected AbstractConnector createAJPConnector(URL url) {
        logger.info((Object)("Creating AJP13 connector on: " + url));
        Ajp13SocketConnector connector = new Ajp13SocketConnector();
        return connector;
    }

    protected Handler createRootHandler() throws ConfigurationException {
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)this.getServer(), "/", 1);
        ServletHolder servletHolder = new ServletHolder((javax.servlet.Servlet)new Servlet(this.gateway));
        root.addServlet(servletHolder, "/*");
        URL u = ((Object)((Object)this)).getClass().getResource("/eu/unicore/gateway");
        root.setResourceBase(u.toString());
        logger.debug((Object)("Adding resources servlet, base=" + u.toString()));
        root.addServlet(DefaultServlet.class, "/resources/*");
        return root;
    }
}

