/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import eu.unicore.gateway.Site;
import eu.unicore.gateway.util.LogUtil;
import eu.unicore.gateway.util.XURI;
import eu.unicore.security.canl.AuthnAndTrustProperties;
import eu.unicore.util.Log;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.commons.httpclient.HttpClient;
import org.apache.log4j.Logger;

public class VSite
implements Site {
    private static final Logger log = Log.getLogger((String)"unicore.gateway", VSite.class);
    private static final ExecutorService pingService = new ThreadPoolExecutor(2, 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private final String name;
    private final URI virtualURI;
    private final int index;
    private final int offset;
    private final boolean isSecure;
    private final URI realURI;
    private final InetAddress inetaddress;
    private final AuthnAndTrustProperties securityCfg;
    private HttpClient client;
    private int numberOfRequests;
    private String errorMessage = "OK";
    private Boolean isUp = null;

    public VSite(URI gatewayURI, String name, String uri, AuthnAndTrustProperties securityCfg) throws UnknownHostException, URISyntaxException {
        URI realuri;
        if (uri == null) {
            throw new IllegalArgumentException("URI can't be null.");
        }
        this.realURI = realuri = new URI(uri);
        this.inetaddress = InetAddress.getByName(this.getRealURI().getHost());
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("VSite needs a name.");
        }
        this.name = name;
        this.virtualURI = new URI(gatewayURI + "/" + name);
        this.index = new XURI(gatewayURI).countPathElements();
        this.offset = name.length() + 2;
        this.isSecure = "HTTPS".equalsIgnoreCase(realuri.getScheme());
        this.securityCfg = securityCfg;
        log.info((Object)("new virtual site: <" + this.virtualURI.toString() + "> at <" + uri + ">"));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public URI getVirtualURI() {
        return this.virtualURI;
    }

    public URI getRealURI() {
        return this.realURI;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public InetAddress getInetAddress() {
        return this.inetaddress;
    }

    @Override
    public int getNumberOfRequests() {
        return this.numberOfRequests;
    }

    @Override
    public String getStatusMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean ping() {
        return this.ping(2000);
    }

    @Override
    public boolean ping(int timeout) {
        Future<Boolean> res = pingService.submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() {
                Socket s = null;
                try {
                    Object factory;
                    if (VSite.this.isSecure) {
                        factory = SocketFactoryCreator.getSocketFactory((X509Credential)VSite.this.securityCfg.getCredential(), (X509CertChainValidator)VSite.this.securityCfg.getValidator());
                        s = ((SocketFactory)factory).createSocket(VSite.this.getRealURI().getHost(), VSite.this.getRealURI().getPort());
                        ((SSLSocket)s).getSession();
                    } else {
                        s = new Socket(VSite.this.getInetAddress(), VSite.this.getRealURI().getPort());
                    }
                    VSite.this.errorMessage = "OK";
                    if (VSite.this.isUp == null || !VSite.this.isUp.booleanValue()) {
                        log.info((Object)("VSite '" + VSite.this.name + "' @ " + VSite.this.getRealURI() + " is up."));
                        VSite.this.isUp = true;
                    }
                    factory = Boolean.TRUE;
                    return factory;
                }
                catch (ConnectException ce) {
                    if (VSite.this.isUp == null || VSite.this.isUp.booleanValue()) {
                        log.info((Object)("VSite '" + VSite.this.name + "' @ " + VSite.this.getRealURI() + " is down."));
                        VSite.this.isUp = false;
                    }
                    VSite.this.errorMessage = "Site is down: connection refused.";
                }
                catch (Exception e) {
                    LogUtil.logException((String)"Error pinging site", (Throwable)e, (Logger)log);
                    VSite.this.errorMessage = "Site unavailable: " + Log.getDetailMessage((Throwable)e);
                }
                finally {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (IOException ioe) {
                            LogUtil.logException((String)"Error closing socket", (Throwable)ioe, (Logger)log);
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
        try {
            Boolean result = res.get(timeout, TimeUnit.MILLISECONDS);
            return result;
        }
        catch (Exception tex) {
            LogUtil.logException((String)"Error waiting for ping result", (Throwable)tex, (Logger)log);
            this.errorMessage = "Timeout";
            return false;
        }
    }

    public String resolve(String uri) {
        int start = uri.toLowerCase().indexOf("/" + this.name.toLowerCase() + "/") + this.offset;
        String endpart = uri.substring(start);
        if (endpart.trim().length() == 0) {
            return this.getRealURI().toString();
        }
        return this.getRealURI() + "/" + endpart;
    }

    @Override
    public boolean accept(String uri) {
        try {
            boolean decision;
            XURI xuri = new XURI(new URI(uri));
            String sitename = xuri.getPathElement(this.index);
            boolean bl = decision = sitename != null && sitename.equalsIgnoreCase(this.getName());
            if (log.isTraceEnabled()) {
                log.trace((Object)("is " + uri + " a correct URI for this (" + this.toString() + ")Vsite ? " + decision));
            }
            if (decision) {
                ++this.numberOfRequests;
            }
            return decision;
        }
        catch (URISyntaxException e) {
            LogUtil.logException("cannot parse the uri, " + uri + ". this must happen before attempting to map to a registered vsite", e);
            return false;
        }
    }

    @Override
    public final VSite select(String clientIP) {
        return this;
    }

    public String toString() {
        return "VSite ::: name=" + this.getName() + ", virtualuri=" + this.getVirtualURI() + ", " + "realuri=" + this.getRealURI().toString() + ", inetaddress=" + this.getInetAddress();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.realURI == null ? 0 : this.realURI.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VSite other = (VSite)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.realURI == null ? other.realURI != null : !this.realURI.equals(other.realURI));
    }
}

