/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway;

import eu.unicore.gateway.BaseSiteOrganiser;
import eu.unicore.gateway.Gateway;
import eu.unicore.gateway.Site;
import eu.unicore.gateway.SiteFactory;
import eu.unicore.gateway.VSite;
import eu.unicore.gateway.properties.ConnectionsProperties;
import eu.unicore.gateway.util.LogUtil;
import eu.unicore.util.configuration.ConfigurationException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class StaticSiteOrganiser
extends BaseSiteOrganiser {
    private static final Logger log = LogUtil.getLogger((String)"unicore.gateway", StaticSiteOrganiser.class);
    private ConnectionsProperties props;

    public StaticSiteOrganiser(Gateway gw, File connections) throws ConfigurationException, IOException {
        super(gw);
        this.props = new ConnectionsProperties(connections);
        this.readConnectionsFile();
    }

    @Override
    public Collection<Site> getSites() {
        this.rereadConnectionsFile();
        return super.getSites();
    }

    @Override
    public VSite match(String wsato, String clientIP) {
        this.rereadConnectionsFile();
        return super.match(wsato, clientIP);
    }

    private void rereadConnectionsFile() {
        try {
            if (!this.props.reloadIfChanged()) {
                return;
            }
        }
        catch (IOException e1) {
            LogUtil.logException((String)"I/O problem reading connections file", (Throwable)e1, (Logger)log);
        }
        this.readConnectionsFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConnectionsFile() {
        log.info((Object)"Reading connections file.");
        Map map = this.sites;
        synchronized (map) {
            this.sites.clear();
            Iterator<Object> it = this.props.getEntries();
            while (it.hasNext()) {
                String siteName = (String)it.next();
                String addr = this.props.getSite(siteName);
                try {
                    Site site = SiteFactory.buildSite(this.gateway.getHostURI(), siteName, addr, this.gateway.getSecurityProperties());
                    if (this.sites.put(siteName, site) != null) continue;
                    log.info((Object)("Added site : " + site.toString()));
                }
                catch (URISyntaxException e) {
                    LogUtil.logException((String)("cannot parse " + addr + " from the connections file. ingnoring this entry."), (Throwable)e, (Logger)log);
                }
                catch (UnknownHostException e) {
                    LogUtil.logException((String)("cannot get a Inetaddress for " + addr), (Throwable)e, (Logger)log);
                }
                catch (IOException e) {
                    LogUtil.logException((String)"I/O problem", (Throwable)e, (Logger)log);
                }
            }
        }
    }
}

