/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway;

import com.ctc.wstx.stax.WstxEventFactory;
import eu.unicore.gateway.HeadersParser;
import eu.unicore.gateway.IConsignorProducer;
import eu.unicore.gateway.SiteOrganiser;
import eu.unicore.gateway.VSite;
import eu.unicore.gateway.base.RawMessageExchange;
import eu.unicore.gateway.client.HttpClientFactory;
import eu.unicore.gateway.soap.SoapFault;
import eu.unicore.gateway.soap.SoapVersion;
import eu.unicore.gateway.util.AbstractStreamReaderRequestEntity;
import eu.unicore.gateway.util.BufferingProxyReader;
import eu.unicore.gateway.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javanet.staxutils.XMLStreamEventWriter;
import javax.servlet.ServletException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;
import org.codehaus.stax2.XMLOutputFactory2;

public class POSTHandler {
    private static final Logger log = LogUtil.getLogger((String)"unicore.gateway", POSTHandler.class);
    private final boolean chunked;
    private final SiteOrganiser organiser;
    private final IConsignorProducer consignorProducer;
    private final HttpClientFactory clientFactory;
    private final String serverUri;
    private HeadersParser hdrParser;
    private static final int FORWARD_BUF_SIZE = 10240;

    public POSTHandler(SiteOrganiser organiser, IConsignorProducer consignorProducer, HttpClientFactory clientFactory, boolean chunked, String serverUri) {
        this.organiser = organiser;
        this.consignorProducer = consignorProducer;
        this.chunked = chunked;
        this.clientFactory = clientFactory;
        this.serverUri = serverUri;
        this.hdrParser = new HeadersParser(serverUri);
    }

    public void invoke(final RawMessageExchange exchange) throws Exception {
        String destination = "?";
        try {
            this.hdrParser.parseHeaders(exchange);
            final X509Certificate[] certs = (X509Certificate[])exchange.getProperty("cert");
            final String clientIP = (String)exchange.getProperty("peer");
            VSite site = this.figureOutDestination(exchange);
            destination = exchange.getDestination();
            URI uri = URI.create(destination);
            AbstractStreamReaderRequestEntity requestentity = null;
            if (this.chunked) {
                requestentity = new AbstractStreamReaderRequestEntity(){

                    @Override
                    public void writeRequest(OutputStream os) throws IOException {
                        try {
                            POSTHandler.writeToOutputStream(exchange, os, certs, clientIP, POSTHandler.this.consignorProducer, log);
                        }
                        catch (XMLStreamException e) {
                            IOException ioe = new IOException();
                            ioe.initCause(e);
                            throw ioe;
                        }
                    }
                };
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                POSTHandler.writeToOutputStream(exchange, baos, certs, clientIP, this.consignorProducer, log);
                requestentity = new ByteArrayRequestEntity(baos.toByteArray());
            }
            log.debug((Object)("Dispatching to: " + destination));
            PostMethod post = this.prepareForwardedPOST(uri, exchange, requestentity);
            this.callServiceAndForwardResponse(post, uri, exchange, site);
            log.debug((Object)("Exchange with " + destination + " successfully completed"));
        }
        catch (SoapFault e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            LogUtil.logException((String)("Problem during dispatch to " + destination), (Throwable)cause, (Logger)log);
            if (exchange.getSoapVersion() != null) {
                e.writeFaultToWriter(exchange.getWriter(), exchange.getSoapVersion());
            }
            throw new ServletException("The request doesn't look like a valid SOAP request.");
        }
    }

    private PostMethod prepareForwardedPOST(URI uri, RawMessageExchange exchange, RequestEntity reqEntity) throws Exception {
        StringBuilder path = new StringBuilder(uri.getPath());
        if (uri.getQuery() != null) {
            path.append("?");
            path.append(uri.getQuery());
        }
        PostMethod post = this.clientFactory.makePostMethod(path.toString(), reqEntity);
        String contentType = (String)exchange.getProperty("Content-type");
        if (contentType != null) {
            post.setRequestHeader("Content-type", contentType);
        } else {
            post.setRequestHeader("Content-type", "text/xml; charset=UTF-8");
        }
        String soapAction = (String)exchange.getProperty("soapaction");
        if (soapAction != null) {
            post.setRequestHeader("SOAPAction", soapAction);
        } else {
            soapAction = exchange.getWsaAction();
            if (soapAction != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Generating HTTP SOAPAction from SOAP header: " + soapAction));
                }
                post.setRequestHeader("SOAPAction", soapAction);
            }
        }
        return post;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callServiceAndForwardResponse(PostMethod post, URI serviceUri, RawMessageExchange exchange, VSite site) throws Exception {
        try {
            try {
                HttpClient client = null;
                VSite vSite = site;
                synchronized (vSite) {
                    client = site.getClient();
                    if (client == null) {
                        client = this.clientFactory.makeHttpClient(serviceUri.toURL());
                        site.setClient(client);
                    }
                }
                client.executeMethod((HttpMethod)post);
            }
            catch (Exception e) {
                String reason = "Problem when forwarding a client request to a VSite: " + e.toString();
                log.debug((Object)("Got exception when forwarding a client request to the VSite " + serviceUri + ": " + e));
                throw new SoapFault(this.serverUri, SoapFault.FaultCode.RECEIVER, reason, e);
            }
            log.debug((Object)("Status of dispatch to service: " + post.getStatusLine()));
            int status = post.getStatusCode();
            if (status >= 400 && status < 500) {
                String reason = "Vsite returned error: " + post.getStatusLine();
                log.debug((Object)("Got error when forwarding a client request to the Vsite " + serviceUri + ": " + reason));
                throw new SoapFault(this.serverUri, SoapFault.FaultCode.RECEIVER, reason);
            }
            try {
                String contentEncoding = post.getResponseHeader("Content-Encoding") != null ? post.getResponseHeader("Content-Encoding").getValue() : null;
                InputStream ris = "gzip".equalsIgnoreCase(contentEncoding) ? new GZIPInputStream(post.getResponseBodyAsStream()) : post.getResponseBodyAsStream();
                String responseCharSet = post.getResponseCharSet();
                POSTHandler.forwardResponse(ris, responseCharSet, exchange, log);
            }
            catch (Exception e) {
                String reason = "Problem when forwarding a response from a VSite to a client: " + e.toString();
                log.debug((Object)("Got exception when forwarding a response from the VSite " + serviceUri + ": " + e));
                throw new SoapFault(this.serverUri, SoapFault.FaultCode.RECEIVER, reason, e);
            }
        }
        finally {
            post.releaseConnection();
        }
    }

    private VSite figureOutDestination(RawMessageExchange ex) throws Exception {
        VSite vsite;
        String address = ex.getWsaToAddress();
        String clientIP = (String)ex.getProperty("peer");
        if (address == null) {
            address = ex.getRequestURL();
            log.debug((Object)("No wsa:To header found, using HTTP URL " + address));
        }
        if ((vsite = this.organiser.match(address, clientIP)) == null) {
            throw new SoapFault(this.serverUri, SoapFault.FaultCode.SENDER, "Cannot send message to " + address + ", such a site is not registered with this gateway.", null);
        }
        String destination = vsite.resolve(address);
        ex.setDestination(destination);
        return vsite;
    }

    public static void forwardResponse(InputStream ris, String responseCharSet, RawMessageExchange exchange, Logger log) throws Exception {
        Writer target = exchange.getWriter();
        byte[] buf = new byte[10240];
        int r = ris.read(buf, 0, buf.length);
        while (r > 0) {
            String s = new String(buf, 0, r, responseCharSet);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Response part: " + s));
            }
            target.write(s);
            r = ris.read(buf, 0, buf.length);
        }
        target.flush();
    }

    public static void writeToOutputStream(RawMessageExchange ex, OutputStream os, X509Certificate[] certs, String ip, IConsignorProducer producer, Logger log) throws XMLStreamException, IOException {
        try {
            BufferingProxyReader reader = ex.getReader();
            int boundary = reader.getMarkedPos();
            reader.replay(os, 0, boundary, "UTF-8");
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            POSTHandler.writeConsignorAssertionToBaos(baos, !ex.isHeaderPresent(), certs, ip, ex.getSoapVersion(), producer, log);
            baos.writeTo(os);
            reader.replayRest(os, boundary, "UTF-8");
            char[] buf = new char[1024];
            OutputStreamWriter w = new OutputStreamWriter(os);
            int r = reader.read(buf);
            while (r > 0) {
                ((Writer)w).write(buf, 0, r);
                r = reader.read(buf);
            }
            ((Writer)w).close();
        }
        catch (XMLStreamException e) {
            LogUtil.logException((String)"Error writing to destination.", (Throwable)e, (Logger)log);
            throw e;
        }
    }

    private static void writeConsignorAssertionToBaos(ByteArrayOutputStream baos, boolean createHeader, X509Certificate[] consignorCC, String ip, SoapVersion soapVersion, IConsignorProducer consignorProducer, Logger log) throws XMLStreamException {
        XMLOutputFactory xof = XMLOutputFactory2.newInstance();
        xof.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        XMLStreamWriter xsw = xof.createXMLStreamWriter(baos);
        XMLStreamEventWriter xew = new XMLStreamEventWriter(xsw);
        POSTHandler.writeConsignorAssertion((XMLEventWriter)xew, createHeader, consignorCC, ip, soapVersion, consignorProducer, log);
        xsw.close();
    }

    private static void writeConsignorAssertion(XMLEventWriter xew, boolean createHeader, X509Certificate[] consignorCC, String ip, SoapVersion soapVersion, IConsignorProducer consignorProducer, Logger log) {
        try {
            QName header;
            WstxEventFactory events = null;
            List<XMLEvent> events2 = consignorProducer.getConsignorAssertion(consignorCC, ip, soapVersion);
            if (createHeader) {
                log.debug((Object)"Creating header");
                events = new WstxEventFactory();
                header = soapVersion.getHeader();
                xew.add(events.createStartElement(header.getPrefix(), header.getNamespaceURI(), header.getLocalPart()));
            }
            for (XMLEvent event : events2) {
                xew.add(event);
            }
            if (createHeader) {
                header = soapVersion.getHeader();
                xew.add(events.createEndElement(header.getPrefix(), header.getNamespaceURI(), header.getLocalPart()));
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)"Can't produce Consignor assertion. Shouldn't happen!", (Throwable)e, (Logger)log);
        }
    }
}

