/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway;

import eu.unicore.gateway.base.RawMessageExchange;
import eu.unicore.gateway.soap.Soap11;
import eu.unicore.gateway.soap.Soap12;
import eu.unicore.gateway.soap.SoapFault;
import eu.unicore.gateway.soap.SoapVersion;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class HeadersParser {
    public static final String WSA_200508_NAMESPACE = "http://www.w3.org/2005/08/addressing";
    private String serverUri;

    public HeadersParser(String serverUri) {
        this.serverUri = serverUri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseHeaders(RawMessageExchange exchange) throws Exception {
        XMLEventReader reader = exchange.getEventReader();
        try {
            boolean markAtNextElement = false;
            SoapVersion soap = null;
            int state = 0;
            while (reader.hasNext()) {
                XMLEvent event = reader.peek();
                if ((event.isStartElement() || event.isEndElement()) && markAtNextElement) {
                    markAtNextElement = false;
                    exchange.getReader().setMarkedPos(event.getLocation().getCharacterOffset());
                }
                if (event.isStartElement()) {
                    QName q;
                    QName qName = q = event.isStartElement() ? event.asStartElement().getName() : event.asEndElement().getName();
                    if (state == 0) {
                        if (Soap11.envelope.equals(q)) {
                            soap = Soap11.getInstance();
                            exchange.setSoapVersion(soap);
                            markAtNextElement = true;
                        } else {
                            if (!Soap12.envelope.equals(q)) throw new SoapFault(this.serverUri, SoapFault.FaultCode.VERSION_MISMATCH, "(Supported) SOAP Envelope element is not the first element");
                            soap = Soap12.getInstance();
                            exchange.setSoapVersion(soap);
                            markAtNextElement = true;
                        }
                        state = 1;
                    } else if (state == 1) {
                        if (!soap.getHeader().equals(q)) {
                            if (!q.equals(soap.getBody())) throw new SoapFault(this.serverUri, SoapFault.FaultCode.VERSION_MISMATCH, "SOAP Envelope must possess Header or Body as its first child element");
                            return;
                        }
                        markAtNextElement = true;
                        exchange.setHeaderPresent(true);
                        state = 2;
                    } else if (state == 2) {
                        if (q.getNamespaceURI().equals(WSA_200508_NAMESPACE)) {
                            this.processWSA(exchange);
                            continue;
                        }
                        if (q.equals(soap.getBody())) {
                            return;
                        }
                    }
                }
                event = reader.nextEvent();
            }
            return;
        }
        catch (XMLStreamException ise) {
            throw new SoapFault(this.serverUri, SoapFault.FaultCode.SENDER, "Failed to parse headers!", ise);
        }
        catch (IOException ioe) {
            throw new SoapFault(this.serverUri, SoapFault.FaultCode.SENDER, "Failed to parse headers!", ioe);
        }
    }

    private void processWSA(RawMessageExchange exchange) throws Exception {
        XMLEvent event;
        XMLEventReader reader = exchange.getEventReader();
        XMLEvent e = reader.nextEvent();
        if (e == null || !e.isStartElement()) {
            return;
        }
        String element = e.asStartElement().getName().getLocalPart();
        while (reader.hasNext() && !(event = reader.nextEvent()).isEndElement()) {
            if (!event.isCharacters()) continue;
            String data = event.asCharacters().getData();
            if (element.equals("To")) {
                exchange.setWsaToAddress(data);
                continue;
            }
            if (!element.equals("Action")) continue;
            exchange.setWsaAction(data);
        }
    }
}

