/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway;

import eu.unicore.gateway.CompositeSiteOrganiser;
import eu.unicore.gateway.ConsignorProducer;
import eu.unicore.gateway.DynamicSiteOrganiser;
import eu.unicore.gateway.SiteOrganiser;
import eu.unicore.gateway.base.GatewayJettyServer;
import eu.unicore.gateway.client.HttpClientFactory;
import eu.unicore.gateway.properties.ConnectionsProperties;
import eu.unicore.gateway.properties.GatewayHttpServerProperties;
import eu.unicore.gateway.properties.GatewayProperties;
import eu.unicore.gateway.util.FileWatcher;
import eu.unicore.gateway.util.LogUtil;
import eu.unicore.security.canl.AuthnAndTrustProperties;
import eu.unicore.security.canl.IAuthnAndTrustConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Gateway {
    public static final File FILE_SECURITY_PROPERTIES = new File("conf" + File.separator + "security.properties");
    private static final Logger log = LogUtil.getLogger((String)"unicore.gateway", Gateway.class);
    private GatewayJettyServer jetty;
    private CompositeSiteOrganiser organiser;
    private DynamicSiteOrganiser dynamicOrganiser;
    private String upSince = "---";
    private ConsignorProducer consignorProducer;
    private GatewayProperties gatewayProperties;
    private AuthnAndTrustProperties securityProperties;
    private GatewayHttpServerProperties jettyProperties;
    private HttpClientFactory clientFactory;
    private URI hostURI;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    public static final String VERSION = Gateway.class.getPackage().getImplementationVersion() != null ? Gateway.class.getPackage().getImplementationVersion() : "DEVELOPMENT";
    public static final String RELEASE_VERSION = Gateway.class.getPackage().getSpecificationVersion() != null ? Gateway.class.getPackage().getSpecificationVersion() : "DEVELOPMENT";

    public Gateway() throws Exception {
        this(GatewayProperties.FILE_GATEWAY_PROPERTIES, ConnectionsProperties.FILE_CONNECTIONS_PROPERTIES, FILE_SECURITY_PROPERTIES);
    }

    public Gateway(File mainProperties, File connections, File secProperties) throws Exception {
        this.configureGateway(mainProperties, connections, secProperties);
    }

    private void configureGateway(File mainProperties, File connections, File secProperties) throws Exception {
        String version = Gateway.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "(SNAPSHOT version)";
        }
        String message = "UNICORE Gateway " + version + " starting.";
        log.info((Object)message);
        System.out.println(message);
        this.gatewayProperties = new GatewayProperties(mainProperties);
        this.jettyProperties = new GatewayHttpServerProperties(mainProperties);
        String host = this.gatewayProperties.getHostname();
        String externalHostName = this.gatewayProperties.getExternalHostname();
        if (externalHostName != null) {
            host = externalHostName;
            log.info((Object)("Using '" + externalHostName + "' as gateway address."));
        }
        this.hostURI = URI.create(host);
        this.securityProperties = new AuthnAndTrustProperties(secProperties, "gateway.truststore.", "gateway.credential.");
        this.clientFactory = new HttpClientFactory((IAuthnAndTrustConfiguration)this.securityProperties, this.gatewayProperties);
        this.organiser = new CompositeSiteOrganiser(this, connections);
        if (this.gatewayProperties.isDynamicRegistrationEnabled()) {
            this.dynamicOrganiser = new DynamicSiteOrganiser(this, this.gatewayProperties.getRegistrationExcludes(), this.gatewayProperties.getRegistrationIncludes());
            this.organiser.addSiteOrganiser(this.dynamicOrganiser);
        }
        log.info((Object)this.organiser.toString());
        int tolerance = this.gatewayProperties.getConsTTol();
        int validity = this.gatewayProperties.getConsTVal();
        boolean doSign = this.gatewayProperties.isConsTSign();
        try {
            this.consignorProducer = new ConsignorProducer(doSign, tolerance, validity, this.securityProperties);
        }
        catch (Exception e) {
            LogUtil.logException((String)"Can't create ConsignorProducer instance.", (Throwable)e, (Logger)log);
        }
    }

    public String upSince() {
        return this.upSince;
    }

    public SiteOrganiser getSiteOrganiser() {
        return this.organiser;
    }

    public DynamicSiteOrganiser getDynamicSiteOrganiser() {
        return this.dynamicOrganiser;
    }

    public ConsignorProducer getConsignorProducer() {
        return this.consignorProducer;
    }

    public URI getHostURI() {
        return this.hostURI;
    }

    public HttpClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public GatewayProperties getProperties() {
        return this.gatewayProperties;
    }

    public AuthnAndTrustProperties getSecurityProperties() {
        return this.securityProperties;
    }

    public GatewayHttpServerProperties getJettyProperties() {
        return this.jettyProperties;
    }

    public final String getHeader() {
        String lineSep = System.getProperty("line.separator");
        String s = lineSep + " _    _ _   _ _____ _____ ____  _____  ______" + lineSep + "| |  | | \\ | |_   _/ ____/ __ \\|  __ \\|  ____|" + lineSep + "| |  | |  \\| | | || |   | |  | | |__) | |__" + lineSep + "| |  | | . ` | | || |   | |  | |  _  /|  __|" + lineSep + "| |__| | |\\  |_| |_ |____ |__| | | \\ \\| |____" + lineSep + " \\____/|_| \\_|_____\\_____\\____/|_|  \\_\\______|" + lineSep + "UNICORE Gateway" + lineSep + "Version " + VERSION + ", http://www.unicore.eu";
        return s;
    }

    public void startGateway() throws Exception {
        String message = this.getHeader();
        log.info((Object)message);
        System.out.println(message);
        this.startLogConfigWatcher();
        this.jetty = new GatewayJettyServer(this);
        this.jetty.start();
        this.upSince = new Date().toString();
        message = "UNICORE Gateway startup complete.";
        log.info((Object)message);
        System.out.println(message);
    }

    public void stopGateway() throws Exception {
        this.executorService.shutdownNow();
        this.jetty.stop();
        String message = "UNICORE Gateway stopped.";
        log.info((Object)message);
        System.out.println(message);
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    private void startLogConfigWatcher() {
        final String logConfig = System.getProperty("log4j.configuration");
        if (logConfig == null) {
            log.warn((Object)"No log configuration file set.");
            return;
        }
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        Gateway.reConfigureLog4j(logConfig);
                    }
                    catch (MalformedURLException me) {
                        throw new RuntimeException(me);
                    }
                }
            };
            File logProperties = logConfig.startsWith("file:") ? new File(new URI(logConfig)) : new File(logConfig);
            FileWatcher fw = new FileWatcher(logProperties, r);
            this.executorService.scheduleWithFixedDelay(fw, 5L, 5L, TimeUnit.SECONDS);
        }
        catch (FileNotFoundException fex) {
            log.warn((Object)("Log configuration file <" + logConfig + "> not found."));
        }
        catch (URISyntaxException use) {
            log.warn((Object)("Not a valid URI: <" + logConfig + ">"));
        }
    }

    public static void reConfigureLog4j(String logConfig) throws MalformedURLException {
        log.info((Object)"LOG CONFIG MODIFIED, re-configuring.");
        if (logConfig.startsWith("file:")) {
            PropertyConfigurator.configure((URL)new URL(logConfig));
        } else {
            PropertyConfigurator.configure((String)logConfig);
        }
    }

    public static void main(String[] args) throws Exception {
        File gwProperties = GatewayProperties.FILE_GATEWAY_PROPERTIES;
        File connProperties = ConnectionsProperties.FILE_CONNECTIONS_PROPERTIES;
        File secProperties = FILE_SECURITY_PROPERTIES;
        if (args.length > 0) {
            gwProperties = new File(args[0]);
        }
        if (args.length > 1) {
            connProperties = new File(args[1]);
        }
        if (args.length > 2) {
            secProperties = new File(args[2]);
        }
        try {
            Gateway instance = new Gateway(gwProperties, connProperties, secProperties);
            instance.startGateway();
        }
        catch (Exception e) {
            log.fatal((Object)("FATAL ERROR starting the Gateway, exiting: " + e.toString()));
            System.err.println("FATAL ERROR starting the Gateway, exiting: " + e.toString());
            System.exit(-1);
        }
    }
}

