/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway;

import eu.unicore.gateway.BaseSiteOrganiser;
import eu.unicore.gateway.Gateway;
import eu.unicore.gateway.Site;
import eu.unicore.gateway.VSite;
import eu.unicore.gateway.cluster.MultiSite;
import eu.unicore.gateway.util.LogUtil;
import java.net.URI;
import org.apache.log4j.Logger;

public class DynamicSiteOrganiser
extends BaseSiteOrganiser {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.gateway", DynamicSiteOrganiser.class);
    private String exclPattern;
    private String inclPattern;

    protected DynamicSiteOrganiser(Gateway gw, String exclPattern, String inclPattern) {
        super(gw);
        this.exclPattern = exclPattern;
        this.inclPattern = inclPattern;
    }

    public boolean register(String name, URI realURI) {
        try {
            this.checkExclusion(realURI);
            this.checkInclusion(realURI);
            Site existingSite = (Site)this.sites.get(name);
            if (existingSite != null && existingSite instanceof MultiSite) {
                ((MultiSite)existingSite).registerVsite(realURI);
            } else {
                VSite newSite = new VSite(this.gateway.getHostURI(), name, realURI.toString(), this.gateway.getSecurityProperties());
                this.sites.put(name, newSite);
            }
            return true;
        }
        catch (IllegalArgumentException ae) {
            logger.warn((Object)("Registration of <" + name + "> at " + realURI + " is not possible."), (Throwable)ae);
        }
        catch (Exception e) {
            LogUtil.logException((String)("Can't process registration of <" + name + "> at " + realURI), (Throwable)e, (Logger)logger);
        }
        return false;
    }

    protected void checkExclusion(URI uri) {
        if (this.exclPattern == null) {
            return;
        }
        String[] chk = this.exclPattern.split(" +");
        String test = uri.toString().toLowerCase();
        for (String pattern : chk) {
            if (!test.contains(pattern.toLowerCase())) continue;
            throw new IllegalArgumentException("Registration forbidden, URL contains '" + pattern + "'");
        }
    }

    protected void checkInclusion(URI uri) {
        if (this.inclPattern == null) {
            return;
        }
        String[] chk = this.inclPattern.split(" +");
        String test = uri.toString().toLowerCase();
        for (String pattern : chk) {
            if (!test.contains(pattern.toLowerCase())) continue;
            return;
        }
        throw new IllegalArgumentException("Registration not allowed, URL does not contain one of '" + this.inclPattern + "'");
    }

    void register(Site site) {
        this.sites.put(site.getName(), site);
    }
}

