/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway;

import com.ctc.wstx.stax.WstxEventFactory;
import eu.emi.security.authn.x509.X509Credential;
import eu.unicore.gateway.IConsignorProducer;
import eu.unicore.gateway.soap.SoapVersion;
import eu.unicore.gateway.util.LogUtil;
import eu.unicore.samly2.SAMLConstants;
import eu.unicore.security.UnicoreSecurityFactory;
import eu.unicore.security.canl.AuthnAndTrustProperties;
import eu.unicore.security.consignor.ConsignorAPI;
import eu.unicore.security.consignor.ConsignorAssertion;
import eu.unicore.security.dsig.DSigException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;

public class ConsignorProducer
implements IConsignorProducer {
    private static final Logger log = LogUtil.getLogger((String)"unicore.gateway", ConsignorProducer.class);
    private static final int CACHE_SIZE = 8;
    private String myDN;
    private PrivateKey myKey;
    private int negativeTolerance;
    private int validity;
    private boolean doSigned;
    private LinkedHashMap<X509Certificate, List<XMLEvent>> cache;

    public ConsignorProducer(boolean doSigned, int negativeTolerance, int validity, AuthnAndTrustProperties securityProperties) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        this.negativeTolerance = negativeTolerance;
        this.validity = validity;
        this.doSigned = doSigned;
        this.cache = new LinkedHashMap<X509Certificate, List<XMLEvent>>(10, 1.0f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<X509Certificate, List<XMLEvent>> eldest) {
                return this.size() > 8;
            }
        };
        this.init(securityProperties);
    }

    private void init(AuthnAndTrustProperties securityProperties) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        X509Credential credential = securityProperties.getCredential();
        X509Certificate cert = credential.getCertificate();
        this.myDN = cert.getSubjectX500Principal().getName();
        this.myKey = null;
        if (this.doSigned) {
            this.myKey = credential.getKey();
        }
    }

    @Override
    public List<XMLEvent> getConsignorAssertion(X509Certificate[] certChain, String ip, SoapVersion soapVer) throws Exception {
        X509Certificate cert;
        List<XMLEvent> ret = null;
        X509Certificate x509Certificate = cert = certChain == null ? null : certChain[0];
        if (this.myKey == null && (ret = this.cacheGet(cert)) != null) {
            return ret;
        }
        ret = new ArrayList<XMLEvent>();
        WstxEventFactory events = new WstxEventFactory();
        this.invokeInternal(certChain, ip, (XMLEventFactory)events, ret);
        if (this.myKey == null) {
            this.cacheAdd(cert, ret);
        }
        return ret;
    }

    private void invokeInternal(X509Certificate[] cert, String ip, XMLEventFactory eventFactory, List<XMLEvent> events) throws XMLStreamException, DSigException {
        ConsignorAssertion assertion;
        ConsignorAPI engine = UnicoreSecurityFactory.getConsignorAPI();
        if (cert != null) {
            assertion = this.myKey != null ? engine.generateConsignorToken(this.myDN, cert, this.myKey, this.negativeTolerance, this.validity, SAMLConstants.AuthNClasses.TLS, ip) : engine.generateConsignorToken(this.myDN, cert, SAMLConstants.AuthNClasses.TLS, ip);
        } else {
            log.debug((Object)"Creating ANONYMOUS SAML consignor token");
            assertion = this.myKey != null ? engine.generateConsignorToken(this.myDN, this.negativeTolerance, this.validity, this.myKey, ip) : engine.generateConsignorToken(this.myDN);
        }
        AssertionDocument assertionDoc = assertion.getXML();
        this.save((XmlObject)assertionDoc, eventFactory, events);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Consignor token: " + assertionDoc));
        }
    }

    private void save(XmlObject obj, XMLEventFactory eventFactory, List<XMLEvent> events) throws XMLStreamException {
        XMLEvent ev;
        XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(obj.newXMLStreamReader());
        while (reader.hasNext() && !(ev = reader.nextEvent()).isEndDocument()) {
            events.add(ev);
        }
    }

    private synchronized void cacheAdd(X509Certificate key, List<XMLEvent> value) {
        this.cache.put(key, value);
    }

    private synchronized List<XMLEvent> cacheGet(X509Certificate key) {
        return this.cache.get(key);
    }
}

