/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.gateway;

import eu.unicore.gateway.Gateway;
import eu.unicore.gateway.Site;
import eu.unicore.gateway.SiteOrganiser;
import eu.unicore.gateway.VSite;
import eu.unicore.gateway.cluster.MultiSite;
import java.util.Collection;
import java.util.Formatter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseSiteOrganiser
implements SiteOrganiser {
    protected Gateway gateway;
    protected final Map<String, Site> sites = new ConcurrentHashMap<String, Site>();

    protected BaseSiteOrganiser(Gateway gw) {
        this.gateway = gw;
    }

    @Override
    public Collection<Site> getSites() {
        return this.sites.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VSite match(String wsato, String clientIP) {
        Map<String, Site> map = this.sites;
        synchronized (map) {
            for (Site site : this.getSites()) {
                if (!site.accept(wsato)) continue;
                return site.select(clientIP);
            }
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        for (Site site : this.getSites()) {
            formatter.format(site.toString() + "\n", new Object[0]);
        }
        return sb.toString();
    }

    @Override
    public String toHTMLString() {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        formatter.format("<table class='sitetable'>", new Object[0]);
        boolean even = false;
        formatter.format("<tr class='heading'><td>Site name</td><td>Address</td><td>Requests served</td><td>Status</td><td>Message</td></tr>", new Object[0]);
        for (Site site : this.getSites()) {
            String image;
            String href;
            String css = even ? "even" : "odd";
            String uri = "N/A";
            String name = site.getName();
            if (site instanceof VSite) {
                uri = ((VSite)site).getRealURI().toString();
                href = "<a href='" + uri + "'>" + uri + "</a>";
            } else {
                StringBuilder hr = new StringBuilder();
                for (VSite v : ((MultiSite)site).getConfiguredSites()) {
                    String vsiteUri = v.getRealURI().toString();
                    hr.append("<a href='").append(vsiteUri).append("'>");
                    hr.append(vsiteUri).append("</a>");
                    hr.append("<br/>");
                }
                href = hr.toString();
            }
            int numRequests = site.getNumberOfRequests();
            try {
                image = site.ping() ? "resources/happymonkey.png" : "resources/sadmonkey.png";
            }
            catch (Exception e) {
                image = "resources/sadmonkey.gif";
            }
            String errorMessage = site.getStatusMessage();
            sb.append("\n");
            formatter.format("<tr class='%1$s'><td>%2$10s</td><td>%3$s</td><td align='right'>%4$10d</td><td><img src='%5$s' title='%6$s'/></td><td>%6$s</td></tr>", css, name, href, numRequests, image, errorMessage);
            even = !even;
        }
        formatter.format("\n</table>", new Object[0]);
        return sb.toString();
    }
}

