/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.httpclient;

import eu.unicore.util.httpclient.HttpHostFactory;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.protocol.Protocol;

public class CustomHostConfiguration
extends HostConfiguration
implements Cloneable {
    private static final String DEFAULT_SCHEME = new String(HttpURL.DEFAULT_SCHEME);
    private final HttpHostFactory factory;

    public CustomHostConfiguration(HttpHostFactory factory) {
        this.factory = factory;
    }

    private CustomHostConfiguration(CustomHostConfiguration that) {
        super((HostConfiguration)that);
        this.factory = that.factory;
    }

    public Object clone() {
        return new CustomHostConfiguration(this);
    }

    public void setHost(String host) {
        this.setHost(host, Protocol.getProtocol((String)DEFAULT_SCHEME).getDefaultPort());
    }

    public void setHost(String host, int port) {
        this.setHost(host, port, DEFAULT_SCHEME);
    }

    public synchronized void setHost(String host, int port, String scheme) {
        this.setHost(this.factory.getHost(this, scheme, host, port));
    }
}

