from ucfg_updater import *
from ucfg_utils import info, error

from ucfg_main import ConfigUtilities

import os
import re

class USEUpdater(UUpdaterBase):
	
	def printDescription(self, options):
		info(options, "Updates USE - used as a base class by other updaters")

	#Warning! when subclassing be sure to call this method - this is not an implementation
	# of the supr class run, as it has additional argument.
	def run(self, options, name):
		info(options, "UNICORE Container configuration updater")
		cfgUtil = ConfigUtilities(options, name)

		# we treat wsrflite.xml and uas.properties as a single entity as it is not sure where is what.
		dict = {
			'unicore.wsrflite.baseurl'							: 'container.baseurl',
			'unicore.wsrflite.host'								: 'container.host',
			'unicore.wsrflite.port'								: 'container.port',
			
			'unicore.wsrflite.ssl'								: 'container.security.sslEnabled',
			'unicore.wsrflite.ssl.clientauth'					: 'container.httpServer.requireClientAuthn',

			'unicore.wsrflite.ssl.keystore'						: 'container.security.credential.path',
			'unicore.wsrflite.ssl.keypass'						: 'container.security.credential.password',
			'unicore.wsrflite.ssl.keyalias'						: 'container.security.credential.keyAlias',
			'unicore.wsrflite.ssl.keytype'						: 'container.security.credential.format',
			
			'unicore.wsrflite.ssl.truststore'					: 'container.security.truststore.keystorePath',
			'unicore.wsrflite.ssl.truststorepass'				: 'container.security.truststore.keystorePassword',
			'unicore.wsrflite.ssl.truststoretype'				: 'container.security.truststore.keystoreFormat',
			
			'unicore.wsrflite.persistence.persist'				: 'container.wsrf.persistence.persist',
			
			'unicore.wsrflite.jetty.maxIdleTime'				: 'container.httpServer.maxIdleTime',
			'unicore.wsrflite.jetty.lowResourceMaxIdleTime'		: 'container.httpServer.lowResourceMaxIdleTime',
			'unicore.wsrflite.jetty.maxThreads'					: 'container.httpServer.maxThreads',
			
			'wsrflite.lifetime.default'							: 'container.wsrf.lifetime.default',
			'unicore.wsrflite.sg.defaulttermtime'				: 'container.wsrf.sg.defaulttermtime',
			
			'uas.wsrflite.configfile'							: 'container.configfile',
			'uas.targetsystem.sitename'							: 'container.sitename',
			'uas.registry.global.advertise'						: 'container.registry.globalAdvertise',
			'uas.externalregistry.use'							: 'container.externalregistry.use',
			'uas.externalregistry.autodiscover'					: 'container.externalregistry.autodiscover',
			'uas.gatewayregistration'							: 'container.security.gateway.registration',
			'uas.gatewayregistration.updateinterval'			: 'container.security.gateway.registrationUpdateInterval',
			'uas.onstartup.wait'								: 'container.security.gateway.waitOnStartup',
			'uas.security.accesscontrol'						: 'container.security.accesscontrol',
			'uas.security.accesscontrol.pdp.config'				: 'container.security.accesscontrol.pdpConfig',
			'uas.security.signatures'							: 'container.security.signatures',
			'uas.security.consignor.checksignature'				: 'container.security.gateway.checkSignature',
			'uas.externalregistry.url'							: 'container.externalregistry.url',
			'uas.onstartup'										: 'container.onstartup'
		}

		allPropertyNames = []

		xmlProps = cfgUtil.getWSRFLiteProperties('wsrflite.xml')
		for prop in xmlProps:
			propName = prop.get('name')
			allPropertyNames.append(propName)

		javaProps = cfgUtil.getJavaPropertyKeys('uas.config')
		for prop in javaProps:
			allPropertyNames.append(prop)
		
		
		hasNewStyleType = False
		for propName in allPropertyNames:

			m = re.match('^(uas\.security\.accesscontrol\.)(.*)', propName)
			if m != None and not (propName == 'uas.security.accesscontrol.pdp.config'):
				dict[propName] = 'container.security.accesscontrol.' + m.group(2) 

			m = re.match('^(unicore\.maxInstancesPerUser\.)(.*)', propName)
			if m != None:
				dict[propName] = 'container.wsrf.maxInstancesPerUser.' + m.group(2)
			
			m = re.match('^(wsrflite\.lifetime\.default\.)(.*)', propName)
			if m != None:
				dict[propName] = 'container.wsrf.lifetime.default.' + m.group(2)

			m = re.match('^(uas\.security\.attributes\.)(.*)', propName)
			if m != None:
				dict[propName] = 'container.security.attributes.' + m.group(2)
			
			m = re.match('^(uas\.onstartup\.)(.*)', propName)
			if m != None and not (propName == 'uas.onstartup.wait'):
				dict[propName] = 'container.onstartup.' + m.group(2)

			m = re.match('^(uas\.externalregistry\.url\.)(.*)', propName)
			if m != None:
				dict[propName] = 'container.externalregistry.url.' + m.group(2)
			
			if propName == 'container.security.truststore.type':
				hasNewStyleType = True
			  
			if propName == 'uas.security.gateway.alias':
				info(options, "WARNING: uas.security.gateway.alias property is not supported anymore. You should MANUALLY replace it with container.security.gateway.certificate property, pointing at pem file with gateway's certificate.")

		
		cfgUtil.setWSRFLitePropertyKeys('wsrflite.xml', dict)
		cfgUtil.updateJavaPropertyNames('uas.config', dict)

		dict = {
			'unicore.wsrflite.jetty.lowThreads' : 'unicore.wsrflite.jetty.lowThreads property is not available anymore without a direct replacement. You can check the container.httpServer.highLoadConnections property documentation for a close counterpart.',
			'username.token.security' : 'username.token.security property is not available anymore without a replacement - the feature was removed.',
			'uas.registry.global' : 'uas.registry.global property is not available anymore without a replacement - it was not used anyway.'
		}

		cfgUtil.commentWSRFLiteProperties('wsrflite.xml', dict);
		cfgUtil.commentJavaProperties('uas.config', dict);

		cfgUtil.setXMLAttribute('wsrflite.xml', "/services/service[@name='Registry']/implementation", \
							'class', 'de.fzj.unicore.wsrflite.xmlbeans.registry.LocalRegistryHomeImpl');		
		cfgUtil.setXMLAttribute('wsrflite.xml', "/services/service[@name='Registry']/interface", \
							'class', 'de.fzj.unicore.wsrflite.xmlbeans.sg.Registry');		
		cfgUtil.setXMLAttribute('wsrflite.xml', "/services/service[@name='ServiceGroupEntry']/implementation", \
							'class', 'de.fzj.unicore.wsrflite.xmlbeans.registry.LocalRegistryEntryHomeImpl');		
		
		dict={}
		if not hasNewStyleType:
			dict['container.security.truststore.type'] ='keystore';
		cfgUtil.setWSRFLiteProperties('wsrflite.xml', dict);

		info(options, "IMPORTANT: Security properties were updated to the new format. Note that you should review the new settings and consider MANY new available options, described in documentation.")
			
		info(options, "Finished update of configuration of UNICORE Container")


