""" 
    Base class of all configuration updaters, must be extended.
"""

class UUpdaterBase(object):
    def printDescription(self, options):
        """
            Prints a short description, need to be overridden.
        """
        pass


    def run(self, options):
        """
            Needs to be overriden to provide an actual implementation. 
            
            Parameters: <parsed command line options>
        """
        pass
