'''
    Utility methods allowing to reconfigure UNICORE components easily.
    Low level interface, rather not used directly in configurators.
'''
import ucfg_utils
from ucfg_utils import info, checkXPathExistence, setXMLElementAttributes
from ucfg_main import ConfigUtilities

from lxml import etree

__idbNSPrefixMap = {
    'idb' : 'http://www.fz-juelich.de/unicore/xnjs/idb',
    'jsdl' : 'http://schemas.ggf.org/jsdl/2005/11/jsdl'
}


class IDBConfigUtilities(ConfigUtilities):

    def __init__(self, options, component):
        super(self.__class__, self).__init__(options, component)


    def setIDBProperties(self, fileName, valsDict):
        filePath = self._prepare(fileName)
        doc = ucfg_utils.loadXMLDocumentFromFile(self.options, filePath)
        for prop in valsDict:
            _setIDBProperty(self.options, doc, prop, valsDict[prop])
        ucfg_utils.writeXMLDocument(self.options, doc, filePath)


    def setIDBResourcesLimits(self, fileName, valsDict):
        filePath = self._prepare(fileName)
        doc = ucfg_utils.loadXMLDocumentFromFile(self.options, filePath)
        for prop in valsDict:
            valuesList = valsDict[prop]
            assert len(valuesList) == 3
            _setTSResourceLimits(self.options, doc, prop, valuesList[0], valuesList[1], valuesList[2])
        ucfg_utils.writeXMLDocument(self.options, doc, filePath)



def _setIDBProperty(options, xmlDoc, name, value):
    '''
        Sets IDB property.
    '''
    propertyXPath = "/idb:IDB/idb:Property[@name='" + name + "']"
    if not checkXPathExistence(options, xmlDoc, propertyXPath, __idbNSPrefixMap):
        if value != None:
            propertyElement = etree.Element(('{' + __idbNSPrefixMap['idb'] + '}Property'))
            propertyElement.set('name', name)
            propertyElement.set('value', value)
            idbElement = xmlDoc.xpath('/idb:IDB', __idbNSPrefixMap)
            assert len(idbElement) == 1
            info(options, " - appending property '" + name + "' with value '" + value + "'")
            idbElement[0].append(propertyElement)
        else:
            info(options, " - property value is None, skipping '" + propertyXPath + "'...")
    else:
        setXMLElementAttributes(options, xmlDoc, propertyXPath, { 'value' : value })


def _setTSResourceLimits(options, xmlDoc, name, exactValue, lowerValue, upperValue):
    '''
        Sets TS resource.
    '''
    elementXPath = "/idb:IDB/idb:TargetSystemProperties/jsdl:Resources/jsdl:" + name
        # /idb:IDB/idb:TargetSystemProperties/jsdl:Resources/jsdl:IndividualCPUTime
        # /idb:IDB/idb:TargetSystemProperties/jsdl:Resources/jsdl:IndividualPhysicalMemory
        # /idb:IDB/idb:TargetSystemProperties/jsdl:Resources/jsdl:IndividualCPUCount
        # /idb:IDB/idb:TargetSystemProperties/jsdl:Resources/jsdl:TotalResourceCount
        # /idb:IDB/idb:TargetSystemProperties/jsdl:Resources/jsdl:TotalCPUCount
    elements = xmlDoc.xpath(elementXPath, namespaces = __idbNSPrefixMap)
    if len(elements) == 1:
        resElement = elements[0]

        if exactValue != None:
            exactElements = resElement.xpath("jsdl:Exact", namespaces = __idbNSPrefixMap)
            if len(exactElements) == 0:
                exactElement = etree.Element(('{' + __idbNSPrefixMap['jsdl'] + '}Exact'))
                exactElement.text = exactValue
                resElement.append(exactElement)
                info(options, " - appending default for '" + name + "' with value '" + exactValue + "'")
            else:
                assert len(exactElements) == 1
                exactElements[0].text = exactValue
                info(options, " - setting default for '" + name + "' to value '" + exactValue + "'")

        if lowerValue != None:
            lowerElements = resElement.xpath("jsdl:Range/jsdl:LowerBound", namespaces = __idbNSPrefixMap)
            assert len(lowerElements) == 1
            lowerElements[0].text = lowerValue
            info(options, " - setting lower bound limit for '" + name + "' to value '" + exactValue + "'")

        if upperValue != None:
            upperElements = resElement.xpath("jsdl:Range/jsdl:UpperBound", namespaces = __idbNSPrefixMap)
            assert len(upperElements) == 1
            upperElements[0].text = upperValue
            info(options, " - setting upper bound limit for '" + name + "' to value '" + exactValue + "'")

    else:
        info(options, " wrong number of TS resource property '" + name + "' in IDB (sould be 1)")

