from ucfg_configurator import *
from ucfg_utils import info
from ucfg_main import ConfigUtilities

# Base class (not a configurator per se) which can be extended by other configurators
# configuring USE based components.

#TODO - implement me
class USEConfigurator(UConfiguratorBase):
	__use_params = {
			'unicore.wsrflite.host' 		: '__REQUIRED##Host address on which container will listen',
			'unicore.wsrflite.port'			: '__REQUIRED##Port on which container will listen'
	}

	def getParams(self):
		p = self.addCredAndTrustParams('container.security', self.__gw_params)
		p = self.addStartupParams('container', p, 256);
		return p

	def run(self, options, config, section, params):
		info(options, "Services Container configurator (" + section + ")")
		cfgUtil = ConfigUtilities(options, section)

		# startup.properties
		cfgUtil.setShellVariables('startup.properties', self.prepareStartupDict('container', params))

		# wsrflite.xml
		useContainerProperties = {
			'unicore.wsrflite.host' 				: params['unicore.wsrflite.host'],
			'unicore.wsrflite.port' 				: params['unicore.wsrflite.port']
		}
		self.prepareCredAndTrustDict('container.security', useContainerProperties)
		cfgUtil.setWSRFLiteProperties('wsrflite.xml', useContainerProperties)

		info(options, "Finished USE (" + section + ")")

