/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.impl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.security.credential.AbstractCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreX509CredentialAdapter
extends AbstractCredential
implements X509Credential {
    private Logger log = LoggerFactory.getLogger(KeyStoreX509CredentialAdapter.class);
    private KeyStore keyStore;
    private String credentialAlias;
    private char[] keyPassword;

    public KeyStoreX509CredentialAdapter(KeyStore store, String alias, char[] password) {
        this.keyStore = (KeyStore)Constraint.isNotNull((Object)store, (String)"Keystore must be supplied");
        this.credentialAlias = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)alias), (String)"Keystore alias must be supplied");
        this.keyPassword = password;
    }

    public Collection<X509CRL> getCRLs() {
        return Collections.EMPTY_LIST;
    }

    public X509Certificate getEntityCertificate() {
        try {
            return (X509Certificate)this.keyStore.getCertificate(this.credentialAlias);
        }
        catch (KeyStoreException e) {
            this.log.error("Error accessing {} certificates in keystore", (Throwable)e);
            return null;
        }
    }

    public Collection<X509Certificate> getEntityCertificateChain() {
        ArrayList<X509Certificate> certsCollection = Collections.EMPTY_LIST;
        try {
            Certificate[] certs = this.keyStore.getCertificateChain(this.credentialAlias);
            if (certs != null) {
                certsCollection = new ArrayList<X509Certificate>(certs.length);
                for (Certificate cert : certs) {
                    certsCollection.add((X509Certificate)cert);
                }
            }
        }
        catch (KeyStoreException e) {
            this.log.error("Error accessing {} certificates in keystore", (Throwable)e);
        }
        return certsCollection;
    }

    public PrivateKey getPrivateKey() {
        try {
            return (PrivateKey)this.keyStore.getKey(this.credentialAlias, this.keyPassword);
        }
        catch (Exception e) {
            this.log.error("Error accessing {} private key in keystore", (Throwable)e);
            return null;
        }
    }

    public PublicKey getPublicKey() {
        return this.getEntityCertificate().getPublicKey();
    }

    public Class<? extends Credential> getCredentialType() {
        return X509Credential.class;
    }

    public void setEntityId(String newEntityID) {
        super.setEntityId(newEntityID);
    }

    public void setUsageType(UsageType newUsageType) {
        super.setUsageType(newUsageType);
    }
}

