/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.impl;

import com.google.common.base.Strings;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.opensaml.security.SecurityException;
import org.opensaml.security.x509.InternalX500DNHandler;
import org.opensaml.security.x509.X500DNHandler;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.security.x509.impl.X509CredentialNameEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicX509CredentialNameEvaluator
implements X509CredentialNameEvaluator {
    private final Logger log = LoggerFactory.getLogger(BasicX509CredentialNameEvaluator.class);
    private boolean checkSubjectAltNames;
    private boolean checkSubjectDNCommonName;
    private boolean checkSubjectDN;
    private Set<Integer> subjectAltNameTypes;
    private X500DNHandler x500DNHandler = new InternalX500DNHandler();

    public BasicX509CredentialNameEvaluator() {
        this.subjectAltNameTypes = new HashSet<Integer>(5);
        this.setCheckSubjectAltNames(true);
        this.setCheckSubjectDNCommonName(true);
        this.setCheckSubjectDN(true);
        this.subjectAltNameTypes.add(X509Support.DNS_ALT_NAME);
        this.subjectAltNameTypes.add(X509Support.URI_ALT_NAME);
    }

    public boolean isNameCheckingActive() {
        return this.checkSubjectAltNames() || this.checkSubjectDNCommonName() || this.checkSubjectDN();
    }

    public Set<Integer> getSubjectAltNameTypes() {
        return this.subjectAltNameTypes;
    }

    public boolean checkSubjectAltNames() {
        return this.checkSubjectAltNames;
    }

    public void setCheckSubjectAltNames(boolean check) {
        this.checkSubjectAltNames = check;
    }

    public boolean checkSubjectDNCommonName() {
        return this.checkSubjectDNCommonName;
    }

    public void setCheckSubjectDNCommonName(boolean check) {
        this.checkSubjectDNCommonName = check;
    }

    public boolean checkSubjectDN() {
        return this.checkSubjectDN;
    }

    public void setCheckSubjectDN(boolean check) {
        this.checkSubjectDN = check;
    }

    public X500DNHandler getX500DNHandler() {
        return this.x500DNHandler;
    }

    public void setX500DNHandler(X500DNHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("X500DNHandler may not be null");
        }
        this.x500DNHandler = handler;
    }

    @Override
    public boolean evaluate(X509Credential credential, Set<String> trustedNames) throws SecurityException {
        if (!this.isNameCheckingActive()) {
            this.log.debug("No trusted name options are active, skipping name evaluation");
            return true;
        }
        if (trustedNames == null || trustedNames.isEmpty()) {
            this.log.debug("Supplied trusted names are null or empty, skipping name evaluation");
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checking trusted names against credential: {}", (Object)X509Support.getIdentifiersToken((X509Credential)credential, (X500DNHandler)this.x500DNHandler));
            this.log.debug("Trusted names being evaluated are: {}", (Object)trustedNames.toString());
        }
        return this.processNameChecks(credential, trustedNames);
    }

    protected boolean processNameChecks(X509Credential credential, Set<String> trustedNames) {
        X509Certificate entityCertificate = credential.getEntityCertificate();
        if (this.checkSubjectAltNames() && this.processSubjectAltNames(entityCertificate, trustedNames)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Credential {} passed name check based on subject alt names.", (Object)X509Support.getIdentifiersToken((X509Credential)credential, (X500DNHandler)this.x500DNHandler));
            }
            return true;
        }
        if (this.checkSubjectDNCommonName() && this.processSubjectDNCommonName(entityCertificate, trustedNames)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Credential {} passed name check based on subject common name.", (Object)X509Support.getIdentifiersToken((X509Credential)credential, (X500DNHandler)this.x500DNHandler));
            }
            return true;
        }
        if (this.checkSubjectDN() && this.processSubjectDN(entityCertificate, trustedNames)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Credential {} passed name check based on subject DN.", (Object)X509Support.getIdentifiersToken((X509Credential)credential, (X500DNHandler)this.x500DNHandler));
            }
            return true;
        }
        this.log.error("Credential failed name check: " + X509Support.getIdentifiersToken((X509Credential)credential, (X500DNHandler)this.x500DNHandler));
        return false;
    }

    protected boolean processSubjectDNCommonName(X509Certificate certificate, Set<String> trustedNames) {
        this.log.debug("Processing subject DN common name");
        X500Principal subjectPrincipal = certificate.getSubjectX500Principal();
        List commonNames = X509Support.getCommonNames((X500Principal)subjectPrincipal);
        if (commonNames == null || commonNames.isEmpty()) {
            return false;
        }
        String commonName = (String)commonNames.get(0);
        this.log.debug("Extracted common name from certificate: {}", (Object)commonName);
        if (Strings.isNullOrEmpty((String)commonName)) {
            return false;
        }
        if (trustedNames.contains(commonName)) {
            this.log.debug("Matched subject DN common name to trusted names: {}", (Object)commonName);
            return true;
        }
        return false;
    }

    protected boolean processSubjectDN(X509Certificate certificate, Set<String> trustedNames) {
        this.log.debug("Processing subject DN");
        X500Principal subjectPrincipal = certificate.getSubjectX500Principal();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Extracted X500Principal from certificate: {}", (Object)this.x500DNHandler.getName(subjectPrincipal));
        }
        for (String trustedName : trustedNames) {
            X500Principal trustedNamePrincipal = null;
            try {
                trustedNamePrincipal = this.x500DNHandler.parse(trustedName);
                this.log.debug("Evaluating principal successfully parsed from trusted name: {}", (Object)trustedName);
                if (!subjectPrincipal.equals(trustedNamePrincipal)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Matched subject DN to trusted names: {}", (Object)this.x500DNHandler.getName(subjectPrincipal));
                }
                return true;
            }
            catch (IllegalArgumentException e) {
                this.log.debug("Trusted name was not a DN or could not be parsed: {}", (Object)trustedName);
            }
        }
        return false;
    }

    protected boolean processSubjectAltNames(X509Certificate certificate, Set<String> trustedNames) {
        this.log.debug("Processing subject alt names");
        Integer[] nameTypes = new Integer[this.subjectAltNameTypes.size()];
        this.subjectAltNameTypes.toArray(nameTypes);
        List altNames = X509Support.getAltNames((X509Certificate)certificate, (Integer[])nameTypes);
        this.log.debug("Extracted subject alt names from certificate: {}", (Object)altNames);
        for (Object altName : altNames) {
            if (!trustedNames.contains(altName)) continue;
            this.log.debug("Matched subject alt name to trusted names: {}", (Object)altName.toString());
            return true;
        }
        return false;
    }
}

