/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.trust.impl;

import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.trust.TrustedCredentialTrustEngine;
import org.opensaml.security.trust.impl.ExplicitX509CertificateTrustEvaluator;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitX509CertificateTrustEngine
implements TrustedCredentialTrustEngine<X509Credential> {
    private final Logger log = LoggerFactory.getLogger(ExplicitX509CertificateTrustEngine.class);
    private CredentialResolver credentialResolver;
    private ExplicitX509CertificateTrustEvaluator trustEvaluator;

    public ExplicitX509CertificateTrustEngine(CredentialResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("Credential resolver may not be null");
        }
        this.credentialResolver = resolver;
        this.trustEvaluator = new ExplicitX509CertificateTrustEvaluator();
    }

    public CredentialResolver getCredentialResolver() {
        return this.credentialResolver;
    }

    public boolean validate(X509Credential untrustedCredential, CriteriaSet trustBasisCriteria) throws SecurityException {
        Iterable trustedCredentials;
        this.checkParams(untrustedCredential, trustBasisCriteria);
        this.log.debug("Attempting to validate untrusted credential");
        try {
            trustedCredentials = this.getCredentialResolver().resolve((Object)trustBasisCriteria);
        }
        catch (ResolverException e) {
            throw new SecurityException("Error resolving trusted credentials", (Exception)((Object)e));
        }
        return this.trustEvaluator.validate(untrustedCredential, trustedCredentials);
    }

    protected void checkParams(X509Credential untrustedCredential, CriteriaSet trustBasisCriteria) throws SecurityException {
        if (untrustedCredential == null) {
            throw new SecurityException("Untrusted credential was null");
        }
        if (trustBasisCriteria == null) {
            throw new SecurityException("Trust basis criteria set was null");
        }
        if (trustBasisCriteria.isEmpty()) {
            throw new SecurityException("Trust basis criteria set was empty");
        }
    }
}

