/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.trust.impl;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.security.SecurityException;
import org.opensaml.security.trust.TrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingTrustEngine<TokenType>
implements TrustEngine<TokenType> {
    private final Logger log = LoggerFactory.getLogger(ChainingTrustEngine.class);
    private List<TrustEngine<TokenType>> engines = new ArrayList<TrustEngine<TokenType>>();

    public List<TrustEngine<TokenType>> getChain() {
        return this.engines;
    }

    public boolean validate(TokenType token, CriteriaSet trustBasisCriteria) throws SecurityException {
        for (TrustEngine<TokenType> engine : this.engines) {
            if (!engine.validate(token, trustBasisCriteria)) continue;
            this.log.debug("Token was trusted by chain member: {}", (Object)engine.getClass().getName());
            return true;
        }
        return false;
    }
}

