/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.impl;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.impl.AbstractCriteriaFilteringCredentialResolver;
import org.opensaml.security.criteria.EntityIDCriterion;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreCredentialResolver
extends AbstractCriteriaFilteringCredentialResolver {
    private final Logger log = LoggerFactory.getLogger(KeyStoreCredentialResolver.class);
    private KeyStore keyStore;
    private Map<String, String> keyPasswords;
    private UsageType keystoreUsage;

    public KeyStoreCredentialResolver(KeyStore store, Map<String, String> passwords) {
        this(store, passwords, null);
    }

    public KeyStoreCredentialResolver(KeyStore store, Map<String, String> passwords, UsageType usage) {
        this.keyStore = (KeyStore)Constraint.isNotNull((Object)store, (String)"Provided key store may not be null");
        try {
            store.size();
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Keystore has not been initialized.");
        }
        this.keystoreUsage = usage != null ? usage : UsageType.UNSPECIFIED;
        this.keyPasswords = passwords;
    }

    @Override
    protected Iterable<Credential> resolveFromSource(CriteriaSet criteriaSet) throws ResolverException {
        this.checkCriteriaRequirements(criteriaSet);
        String entityID = ((EntityIDCriterion)criteriaSet.get(EntityIDCriterion.class)).getEntityID();
        UsageCriterion usageCriteria = (UsageCriterion)criteriaSet.get(UsageCriterion.class);
        UsageType usage = usageCriteria != null ? usageCriteria.getUsage() : UsageType.UNSPECIFIED;
        if (!this.matchUsage(this.keystoreUsage, usage)) {
            this.log.debug("Specified usage criteria {} does not match keystore usage {}", (Object)usage, (Object)this.keystoreUsage);
            this.log.debug("Can not resolve credentials from this keystore");
            return Collections.emptySet();
        }
        KeyStore.PasswordProtection keyPassword = null;
        if (this.keyPasswords.containsKey(entityID)) {
            keyPassword = new KeyStore.PasswordProtection(this.keyPasswords.get(entityID).toCharArray());
        }
        KeyStore.Entry keyStoreEntry = null;
        try {
            keyStoreEntry = this.keyStore.getEntry(entityID, keyPassword);
        }
        catch (UnrecoverableEntryException e) {
            this.log.error("Unable to retrieve keystore entry for entityID (keystore alias): " + entityID);
            this.log.error("Check for invalid keystore entityID/alias entry password");
            throw new ResolverException("Could not retrieve entry from keystore", (Exception)e);
        }
        catch (GeneralSecurityException e) {
            this.log.error("Unable to retrieve keystore entry for entityID (keystore alias): " + entityID, (Throwable)e);
            throw new ResolverException("Could not retrieve entry from keystore", (Exception)e);
        }
        if (keyStoreEntry == null) {
            this.log.debug("Keystore entry for entity ID (keystore alias) {} does not exist", (Object)entityID);
            return Collections.emptySet();
        }
        Credential credential = this.buildCredential(keyStoreEntry, entityID, this.keystoreUsage);
        return Collections.singleton(credential);
    }

    protected void checkCriteriaRequirements(CriteriaSet criteriaSet) {
        EntityIDCriterion entityCriteria = (EntityIDCriterion)criteriaSet.get(EntityIDCriterion.class);
        if (entityCriteria == null) {
            this.log.error("EntityIDCriterion was not specified in the criteria set, resolution can not be attempted");
            throw new IllegalArgumentException("No EntityIDCriterion was available in criteria set");
        }
    }

    protected boolean matchUsage(UsageType keyStoreUsage, UsageType criteriaUsage) {
        if (keyStoreUsage == UsageType.UNSPECIFIED || criteriaUsage == UsageType.UNSPECIFIED) {
            return true;
        }
        return keyStoreUsage == criteriaUsage;
    }

    protected Credential buildCredential(KeyStore.Entry keyStoreEntry, String entityID, UsageType usage) throws ResolverException {
        this.log.debug("Building credential from keystore entry for entityID {}, usage type {}", (Object)entityID, (Object)usage);
        X509Credential credential = null;
        if (keyStoreEntry instanceof KeyStore.PrivateKeyEntry) {
            credential = this.processPrivateKeyEntry((KeyStore.PrivateKeyEntry)keyStoreEntry, entityID, this.keystoreUsage);
        } else if (keyStoreEntry instanceof KeyStore.TrustedCertificateEntry) {
            credential = this.processTrustedCertificateEntry((KeyStore.TrustedCertificateEntry)keyStoreEntry, entityID, this.keystoreUsage);
        } else if (keyStoreEntry instanceof KeyStore.SecretKeyEntry) {
            credential = this.processSecretKeyEntry((KeyStore.SecretKeyEntry)keyStoreEntry, entityID, this.keystoreUsage);
        } else {
            throw new ResolverException("KeyStore entry was of an unsupported type: " + keyStoreEntry.getClass().getName());
        }
        return credential;
    }

    protected X509Credential processTrustedCertificateEntry(KeyStore.TrustedCertificateEntry trustedCertEntry, String entityID, UsageType usage) {
        this.log.debug("Processing TrustedCertificateEntry from keystore");
        X509Certificate cert = (X509Certificate)trustedCertEntry.getTrustedCertificate();
        BasicX509Credential credential = new BasicX509Credential(cert);
        credential.setEntityId(entityID);
        credential.setUsageType(usage);
        ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
        certChain.add(cert);
        credential.setEntityCertificateChain(certChain);
        return credential;
    }

    protected X509Credential processPrivateKeyEntry(KeyStore.PrivateKeyEntry privateKeyEntry, String entityID, UsageType usage) {
        this.log.debug("Processing PrivateKeyEntry from keystore");
        BasicX509Credential credential = new BasicX509Credential((X509Certificate)privateKeyEntry.getCertificate(), privateKeyEntry.getPrivateKey());
        credential.setEntityId(entityID);
        credential.setUsageType(usage);
        credential.setEntityCertificateChain(Arrays.asList((X509Certificate[])privateKeyEntry.getCertificateChain()));
        return credential;
    }

    protected Credential processSecretKeyEntry(KeyStore.SecretKeyEntry secretKeyEntry, String entityID, UsageType usage) {
        this.log.debug("Processing SecretKeyEntry from keystore");
        BasicCredential credential = new BasicCredential(secretKeyEntry.getSecretKey());
        credential.setEntityId(entityID);
        credential.setUsageType(usage);
        return credential;
    }
}

