/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.impl;

import java.util.HashSet;
import java.util.Set;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriteriaRegistry;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.credential.impl.AbstractCredentialResolver;
import org.opensaml.util.criteria.CriteriaFilteringIterable;
import org.opensaml.util.criteria.EvaluableCriterion;

public abstract class AbstractCriteriaFilteringCredentialResolver
extends AbstractCredentialResolver {
    private boolean meetAllCriteria = true;
    private boolean unevaluableSatisfies = true;

    @Override
    public Iterable<Credential> resolve(CriteriaSet criteriaSet) throws ResolverException {
        Iterable<Credential> storeCandidates = this.resolveFromSource(criteriaSet);
        Set<EvaluableCriterion<Credential>> evaluableCriteria = this.getEvaluableCriteria(criteriaSet);
        if (evaluableCriteria.isEmpty()) {
            return storeCandidates;
        }
        return new CriteriaFilteringIterable(storeCandidates, evaluableCriteria, this.meetAllCriteria, this.unevaluableSatisfies);
    }

    public boolean isMeetAllCriteria() {
        return this.meetAllCriteria;
    }

    public void setMeetAllCriteria(boolean flag) {
        this.meetAllCriteria = flag;
    }

    public boolean isUnevaluableSatisfies() {
        return this.unevaluableSatisfies;
    }

    public void setUnevaluableSatisfies(boolean flag) {
        this.unevaluableSatisfies = flag;
    }

    protected abstract Iterable<Credential> resolveFromSource(CriteriaSet var1) throws ResolverException;

    private Set<EvaluableCriterion<Credential>> getEvaluableCriteria(CriteriaSet criteriaSet) throws ResolverException {
        HashSet<EvaluableCriterion<Credential>> evaluable = new HashSet<EvaluableCriterion<Credential>>(criteriaSet.size());
        for (Criterion criteria : criteriaSet) {
            EvaluableCredentialCriterion evaluableCriteria;
            if (criteria instanceof EvaluableCredentialCriterion) {
                evaluable.add((EvaluableCredentialCriterion)criteria);
                continue;
            }
            try {
                evaluableCriteria = EvaluableCredentialCriteriaRegistry.getEvaluator(criteria);
            }
            catch (SecurityException e) {
                throw new ResolverException("Exception obtaining EvaluableCredentialCriterion", (Exception)((Object)e));
            }
            if (evaluableCriteria == null) continue;
            evaluable.add(evaluableCriteria);
        }
        return evaluable;
    }
}

