/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509SubjectNameCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableX509SubjectNameCredentialCriterion
implements EvaluableCredentialCriterion {
    private final Logger log = LoggerFactory.getLogger(EvaluableX509SubjectNameCredentialCriterion.class);
    private X500Principal subjectName;

    public EvaluableX509SubjectNameCredentialCriterion(X509SubjectNameCriterion criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criterion instance may not be null");
        }
        this.subjectName = criteria.getSubjectName();
    }

    public EvaluableX509SubjectNameCredentialCriterion(X500Principal newSubjectName) {
        if (newSubjectName == null) {
            throw new IllegalArgumentException("Subject name may not be null");
        }
        this.subjectName = newSubjectName;
    }

    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        if (!(target instanceof X509Credential)) {
            this.log.info("Credential is not an X509Credential, does not satisfy subject name criteria");
            return Boolean.FALSE;
        }
        X509Credential x509Cred = (X509Credential)target;
        X509Certificate entityCert = x509Cred.getEntityCertificate();
        if (entityCert == null) {
            this.log.info("X509Credential did not contain an entity certificate, does not satisfy criteria");
            return Boolean.FALSE;
        }
        Boolean result = entityCert.getSubjectX500Principal().equals(this.subjectName);
        return result;
    }
}

