/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.criteria.UsageCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableUsageCredentialCriterion
implements EvaluableCredentialCriterion {
    private final Logger log = LoggerFactory.getLogger(EvaluableUsageCredentialCriterion.class);
    private UsageType usage;

    public EvaluableUsageCredentialCriterion(UsageCriterion criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criterion instance may not be null");
        }
        this.usage = criteria.getUsage();
    }

    public EvaluableUsageCredentialCriterion(UsageType newUsage) {
        if (newUsage == null) {
            throw new IllegalArgumentException("Usage may not be null");
        }
        this.usage = newUsage;
    }

    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        UsageType credUsage = target.getUsageType();
        if (credUsage == null) {
            this.log.info("Could not evaluate criteria, credential contained no usage specifier");
            return null;
        }
        Boolean result = this.matchUsage(credUsage, this.usage);
        return result;
    }

    protected boolean matchUsage(UsageType credentialUsage, UsageType criteriaUsage) {
        if (credentialUsage == UsageType.UNSPECIFIED || criteriaUsage == UsageType.UNSPECIFIED) {
            return true;
        }
        return credentialUsage == criteriaUsage;
    }
}

