/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import java.security.PublicKey;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.criteria.PublicKeyCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluablePublicKeyCredentialCriterion
implements EvaluableCredentialCriterion {
    private final Logger log = LoggerFactory.getLogger(EvaluablePublicKeyCredentialCriterion.class);
    private PublicKey publicKey;

    public EvaluablePublicKeyCredentialCriterion(PublicKeyCriterion criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criterion instance may not be null");
        }
        this.publicKey = criteria.getPublicKey();
    }

    public EvaluablePublicKeyCredentialCriterion(PublicKey newPublicKey) {
        if (newPublicKey == null) {
            throw new IllegalArgumentException("Public key may not be null");
        }
        this.publicKey = newPublicKey;
    }

    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        PublicKey key = target.getPublicKey();
        if (key == null) {
            this.log.info("Credential contained no public key, does not satisfy public key criteria");
            return Boolean.FALSE;
        }
        Boolean result = this.publicKey.equals(key);
        return result;
    }
}

