/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import com.google.common.base.Strings;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.criteria.KeyNameCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableKeyNameCredentialCriterion
implements EvaluableCredentialCriterion {
    private final Logger log = LoggerFactory.getLogger(EvaluableKeyNameCredentialCriterion.class);
    private String keyName;

    public EvaluableKeyNameCredentialCriterion(KeyNameCriterion criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criterion instance may not be null");
        }
        this.keyName = criteria.getKeyName();
    }

    public EvaluableKeyNameCredentialCriterion(String newKeyName) {
        if (Strings.isNullOrEmpty((String)newKeyName)) {
            throw new IllegalArgumentException("Key name may not be null");
        }
        this.keyName = newKeyName;
    }

    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        if (target.getKeyNames().isEmpty()) {
            this.log.info("Could not evaluate criteria, credential contained no key names");
            return null;
        }
        Boolean result = target.getKeyNames().contains(this.keyName);
        return result;
    }
}

