/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import java.security.Key;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.criteria.KeyLengthCriterion;
import org.opensaml.security.crypto.KeySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableKeyLengthCredentialCriterion
implements EvaluableCredentialCriterion {
    private final Logger log = LoggerFactory.getLogger(EvaluableKeyLengthCredentialCriterion.class);
    private Integer keyLength;

    public EvaluableKeyLengthCredentialCriterion(KeyLengthCriterion criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criterion instance may not be null");
        }
        this.keyLength = criteria.getKeyLength();
    }

    public EvaluableKeyLengthCredentialCriterion(Integer newKeyLength) {
        if (newKeyLength == null) {
            throw new IllegalArgumentException("Key length may not be null");
        }
        this.keyLength = newKeyLength;
    }

    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        Key key = this.getKey(target);
        if (key == null) {
            this.log.info("Could not evaluate criteria, credential contained no key");
            return null;
        }
        Integer length = KeySupport.getKeyLength((Key)key);
        if (length == null) {
            this.log.info("Could not evaluate criteria, can not determine length of key");
            return null;
        }
        Boolean result = this.keyLength.equals(length);
        return result;
    }

    private Key getKey(Credential credential) {
        if (credential.getPublicKey() != null) {
            return credential.getPublicKey();
        }
        if (credential.getSecretKey() != null) {
            return credential.getSecretKey();
        }
        if (credential.getPrivateKey() != null) {
            return credential.getPrivateKey();
        }
        return null;
    }
}

