/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import com.google.common.base.Strings;
import java.security.Key;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.criteria.KeyAlgorithmCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluableKeyAlgorithmCredentialCriterion
implements EvaluableCredentialCriterion {
    private final Logger log = LoggerFactory.getLogger(EvaluableKeyAlgorithmCredentialCriterion.class);
    private String keyAlgorithm;

    public EvaluableKeyAlgorithmCredentialCriterion(KeyAlgorithmCriterion criteria) {
        if (criteria == null) {
            throw new NullPointerException("Criterion instance may not be null");
        }
        this.keyAlgorithm = criteria.getKeyAlgorithm();
    }

    public EvaluableKeyAlgorithmCredentialCriterion(String newKeyAlgorithm) {
        if (Strings.isNullOrEmpty((String)newKeyAlgorithm)) {
            throw new IllegalArgumentException("Key algorithm may not be null");
        }
        this.keyAlgorithm = newKeyAlgorithm;
    }

    public Boolean evaluate(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return null;
        }
        Key key = this.getKey(target);
        if (key == null) {
            this.log.info("Could not evaluate criteria, credential contained no key");
            return null;
        }
        String algorithm = StringSupport.trimOrNull((String)key.getAlgorithm());
        if (algorithm == null) {
            this.log.info("Could not evaluate criteria, key does not specify an algorithm via getAlgorithm()");
            return null;
        }
        Boolean result = this.keyAlgorithm.equals(algorithm);
        return result;
    }

    private Key getKey(Credential credential) {
        if (credential.getPublicKey() != null) {
            return credential.getPublicKey();
        }
        if (credential.getSecretKey() != null) {
            return credential.getSecretKey();
        }
        if (credential.getPrivateKey() != null) {
            return credential.getPrivateKey();
        }
        return null;
    }
}

