/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import com.novosec.pkix.asn1.crmf.AttributeTypeAndValue;
import com.novosec.pkix.asn1.crmf.CertTemplate;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class CertRequest
implements DEREncodable {
    DERInteger certReqId;
    CertTemplate certTemplate;
    Vector controls = new Vector();

    public static CertRequest getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertRequest.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static CertRequest getInstance(Object obj) {
        if (obj instanceof CertRequest) {
            return (CertRequest)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CertRequest((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CertRequest(ASN1Sequence seq) {
        this.certReqId = DERInteger.getInstance((Object)seq.getObjectAt(0));
        this.certTemplate = CertTemplate.getInstance(seq.getObjectAt(1));
        if (seq.size() > 2) {
            ASN1Sequence s = (ASN1Sequence)seq.getObjectAt(2);
            for (int i = 0; i < s.size(); ++i) {
                this.controls.addElement(AttributeTypeAndValue.getInstance(s.getObjectAt(i)));
            }
        }
    }

    public CertRequest(DERInteger certReqId, CertTemplate certTemplate) {
        this.certReqId = certReqId;
        this.certTemplate = certTemplate;
    }

    public DERInteger getCertReqId() {
        return this.certReqId;
    }

    public CertTemplate getCertTemplate() {
        return this.certTemplate;
    }

    public AttributeTypeAndValue getControls(int nr) {
        if (this.controls.size() > nr) {
            return (AttributeTypeAndValue)this.controls.elementAt(nr);
        }
        return null;
    }

    public void addControls(AttributeTypeAndValue control) {
        this.controls.addElement(control);
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.certReqId);
        v.add((DEREncodable)this.certTemplate);
        if (this.controls.size() > 0) {
            ASN1EncodableVector pubiv = new ASN1EncodableVector();
            for (int i = 0; i < this.controls.size(); ++i) {
                pubiv.add((DEREncodable)((AttributeTypeAndValue)this.controls.elementAt(i)));
            }
            v.add((DEREncodable)new DERSequence(pubiv));
        }
        return new DERSequence(v);
    }

    public String toString() {
        String s = "CertRequest: (certReqId = " + this.getCertReqId() + ", ";
        s = s + "certTemplate: " + this.getCertTemplate() + ", ";
        if (this.controls.size() > 0) {
            s = s + "controls : (";
            for (int i = 0; i < this.controls.size(); ++i) {
                s = s + (AttributeTypeAndValue)this.controls.elementAt(i);
            }
            s = s + ")";
        }
        s = s + ")";
        return s;
    }
}

