/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import com.novosec.pkix.asn1.crmf.AttributeTypeAndValue;
import com.novosec.pkix.asn1.crmf.CertRequest;
import com.novosec.pkix.asn1.crmf.ProofOfPossession;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class CertReqMsg
implements DEREncodable {
    CertRequest certReq;
    ProofOfPossession pop;
    Vector regInfos = new Vector();

    public static CertReqMsg getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertReqMsg.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static CertReqMsg getInstance(Object obj) {
        if (obj instanceof CertReqMsg) {
            return (CertReqMsg)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CertReqMsg((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CertReqMsg(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.certReq = CertRequest.getInstance(e.nextElement());
        Object obj = null;
        if (e.hasMoreElements()) {
            obj = e.nextElement();
        }
        if (obj instanceof ASN1TaggedObject) {
            this.pop = ProofOfPossession.getInstance((DERObject)((ASN1TaggedObject)obj));
            if (e.hasMoreElements()) {
                obj = e.nextElement();
            }
        }
        if (obj instanceof ASN1Sequence) {
            ASN1Sequence s = obj;
            for (int i = 0; i < s.size(); ++i) {
                this.regInfos.addElement(AttributeTypeAndValue.getInstance(s.getObjectAt(i)));
            }
        }
    }

    public CertReqMsg(CertRequest certReq) {
        this.certReq = certReq;
    }

    public CertRequest getCertReq() {
        return this.certReq;
    }

    public ProofOfPossession getPop() {
        return this.pop;
    }

    public void setPop(ProofOfPossession pop) {
        this.pop = pop;
    }

    public AttributeTypeAndValue getRegInfo(int nr) {
        if (this.regInfos.size() > nr) {
            return (AttributeTypeAndValue)this.regInfos.elementAt(nr);
        }
        return null;
    }

    public void addRegInfo(AttributeTypeAndValue regInfo) {
        this.regInfos.addElement(regInfo);
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.certReq);
        if (this.pop != null) {
            v.add((DEREncodable)this.pop);
        }
        if (this.regInfos.size() > 0) {
            ASN1EncodableVector regiv = new ASN1EncodableVector();
            for (int i = 0; i < this.regInfos.size(); ++i) {
                regiv.add((DEREncodable)((AttributeTypeAndValue)this.regInfos.elementAt(i)));
            }
            v.add((DEREncodable)new DERSequence(regiv));
        }
        return new DERSequence(v);
    }

    public String toString() {
        String s = "CertReqMsg: (certReq = " + this.getCertReq() + ", ";
        if (this.getPop() != null) {
            s = s + "pop: " + this.getPop() + ", ";
        }
        if (this.regInfos.size() > 0) {
            s = s + "regInfo : (";
            for (int i = 0; i < this.regInfos.size(); ++i) {
                s = s + (AttributeTypeAndValue)this.regInfos.elementAt(i);
            }
            s = s + ")";
        }
        s = s + ")";
        return s;
    }
}

