/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;

public class AttributeTypeAndValue
implements DEREncodable {
    private DERObjectIdentifier type;
    private DEREncodable value;

    public static AttributeTypeAndValue getInstance(ASN1TaggedObject obj, boolean explicit) {
        return AttributeTypeAndValue.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static AttributeTypeAndValue getInstance(Object obj) {
        if (obj instanceof AttributeTypeAndValue) {
            return (AttributeTypeAndValue)obj;
        }
        if (obj instanceof DERObjectIdentifier) {
            return new AttributeTypeAndValue((DERObjectIdentifier)obj);
        }
        if (obj instanceof String) {
            return new AttributeTypeAndValue((String)obj);
        }
        if (obj instanceof ASN1Sequence) {
            return new AttributeTypeAndValue((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public AttributeTypeAndValue(DERObjectIdentifier type) {
        this.type = type;
    }

    public AttributeTypeAndValue(String type) {
        this.type = new DERObjectIdentifier(type);
    }

    public AttributeTypeAndValue(DERObjectIdentifier type, DEREncodable value) {
        this.type = type;
        this.value = value;
    }

    public AttributeTypeAndValue(ASN1Sequence seq) {
        this.type = (DERObjectIdentifier)seq.getObjectAt(0);
        this.value = seq.getObjectAt(1);
    }

    public DERObjectIdentifier getObjectId() {
        return this.type;
    }

    public DEREncodable getParameters() {
        return this.value;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.type);
        v.add(this.value);
        return new DERSequence(v);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AttributeTypeAndValue)) {
            return false;
        }
        AttributeTypeAndValue other = (AttributeTypeAndValue)o;
        if (!this.getObjectId().equals((Object)other.getObjectId())) {
            return false;
        }
        if (this.getParameters() == null && other.getParameters() == null) {
            return true;
        }
        if (this.getParameters() == null || other.getParameters() == null) {
            return false;
        }
        ByteArrayOutputStream b1Out = new ByteArrayOutputStream();
        ByteArrayOutputStream b2Out = new ByteArrayOutputStream();
        DEROutputStream d1Out = new DEROutputStream((OutputStream)b1Out);
        DEROutputStream d2Out = new DEROutputStream((OutputStream)b2Out);
        try {
            d1Out.writeObject((Object)this.getParameters());
            d2Out.writeObject((Object)other.getParameters());
            byte[] b1 = b1Out.toByteArray();
            byte[] b2 = b2Out.toByteArray();
            if (b1.length != b2.length) {
                return false;
            }
            for (int i = 0; i != b1.length; ++i) {
                if (b1[i] == b2[i]) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

