/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import com.novosec.pkix.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.X509Extensions;

public class RevDetails
implements DEREncodable {
    CertTemplate certDetails;
    DERBitString revocationReason;
    DERGeneralizedTime badSinceDate;
    X509Extensions crlEntryDetails;

    public static RevDetails getInstance(ASN1TaggedObject obj, boolean explicit) {
        return RevDetails.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static RevDetails getInstance(Object obj) {
        if (obj instanceof RevDetails) {
            return (RevDetails)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new RevDetails((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public RevDetails(ASN1Sequence seq) {
        this.certDetails = CertTemplate.getInstance(seq.getObjectAt(0));
        int idx = 1;
        Object obj = null;
        if (idx < seq.size()) {
            obj = seq.getObjectAt(idx++);
        }
        if (obj instanceof DERBitString) {
            this.revocationReason = DERBitString.getInstance((Object)obj);
            obj = idx < seq.size() ? seq.getObjectAt(idx++) : null;
        }
        if (obj instanceof DERGeneralizedTime) {
            this.badSinceDate = DERGeneralizedTime.getInstance((Object)obj);
            obj = idx < seq.size() ? seq.getObjectAt(idx++) : null;
        }
        if (obj instanceof ASN1Sequence) {
            this.crlEntryDetails = X509Extensions.getInstance((Object)obj);
            obj = idx < seq.size() ? seq.getObjectAt(idx++) : null;
        }
        if (obj != null) {
            throw new IllegalArgumentException("unknown object in factory");
        }
    }

    public RevDetails(CertTemplate certDetails) {
        this.certDetails = certDetails;
        this.revocationReason = null;
        this.badSinceDate = null;
        this.crlEntryDetails = null;
    }

    public CertTemplate getCertDetails() {
        return this.certDetails;
    }

    public void setCertDetails(CertTemplate certDetails) {
        this.certDetails = certDetails;
    }

    public DERBitString getRevocationReason() {
        return this.revocationReason;
    }

    public void setRevocationReason(DERBitString revocationReason) {
        this.revocationReason = revocationReason;
    }

    public DERGeneralizedTime getBadSinceDate() {
        return this.badSinceDate;
    }

    public void setBadSinceDate(DERGeneralizedTime badSinceDate) {
        this.badSinceDate = badSinceDate;
    }

    public X509Extensions getCrlEntryDetails() {
        return this.crlEntryDetails;
    }

    public void setCrlEntryDetails(X509Extensions crlEntryDetails) {
        this.crlEntryDetails = crlEntryDetails;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.certDetails);
        if (this.revocationReason != null) {
            v.add((DEREncodable)this.revocationReason);
        }
        if (this.badSinceDate != null) {
            v.add((DEREncodable)this.badSinceDate);
        }
        if (this.crlEntryDetails != null) {
            v.add((DEREncodable)this.crlEntryDetails);
        }
        return new DERSequence(v);
    }

    public String toString() {
        String s = "RevDetails: ( certDetails = " + this.getCertDetails() + ", ";
        if (this.getRevocationReason() != null) {
            s = s + "revocationReason = " + this.getRevocationReason() + ", ";
        }
        if (this.getBadSinceDate() != null) {
            s = s + "badSinceDate = " + this.getBadSinceDate() + ", ";
        }
        if (this.getCrlEntryDetails() != null) {
            s = s + "crlEntryDetails = " + this.getCrlEntryDetails() + ", ";
        }
        s = s + ")";
        return s;
    }
}

